
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_pd',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'data',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'tipo_scrittura_pd',
             'title':'Tipo Scrittura',
             'type':'str',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'Tipo di Scrittura',
             },
            {'name':'conto_pd',
             'title':'Conto Pagamento',
             'type':'str',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'Conto Contabile',
             'ref':'lista_conti/list',
             'refname':'codice_conto'
             },
            {'name':'dare_pd',
             'title':'Importo Dare',
             'type':'float',
             'defvalue':"0",
             'maxlen':2,
             'optional':False,
             'tooltip':'Importo Pagato'
             },
            {'name':'avere_pd',
             'title':'Importo Avere',
             'type':'float',
             'defvalue':"0",
             'maxlen':2,
             'optional':False,
             'tooltip':'Importo Pagato'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Movimenti Contabili",be,fields,delete=False,table="partita_doppia",menu="Contabilita")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)

        #x.addcommand("ddtpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")
