#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


### modulo di esempio....
from module import *

class handler(module):
    def __init__(self,name,db):
        module.__init__(self,name,"Magazzino",db) # serve a identificare il nome mod
        menuprefix=""
        self.addhandler("list",self.list,menuprefix+"/Lista")
        self.addhandler("add",self.add,menuprefix+"/Aggiungi")
        self.addhandler("add-db",self.add_db)
        self.addhandler("mod",self.mod)
        self.addhandler("mod-db",self.mod_db)
        self.addhandler("del",self.del_db)

    def list(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")

        d._push()
        d.command(stock="add",action="magazzino/add",update="true")
        d._pop()

        d._push()
        # definisce il comando delete che modulo/funzione chiama con che valore
        d.command(stock="delete",action="magazzino/del",forwardselection="id_movmage",update="true")
        d._pop()

        d._push()
        d.command(stock="edit",action="magazzino/mod",forwardselection="id_movmage",update="true")
        d._pop()

        d._push()
        d.command(title="Ordinato",action="viste/list_ordinato",update="true")
        d._pop()

        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="id_movmage", title="ID",type="str") #....
        d._pop()

        d._push()
        d.header(name="magazino", title="Magazino", type="str")
        d._pop()

        d._push()
        d.header(name="articolo_movmage", title="Articolo", type="str")
        d._pop()

        d._push()
        d.header(name="q_ta_movmage", title="Quantita\'", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM movimenti_magazino")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def add(self,d,e):
        a=e.attrib 

        
        d._push()
        d.ui(type="amwindow")
        d._push()
        # definisce l'azione del modulo/funzione con il il tipo
        d.dialog(action="magazzino/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Movimento Magagazino")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere un nuovo Movimento Magazzino")
        d._push()
        #### inizio della scheda per movimenti di magazzino ###

        d._push()
        d.field(name="articolo_movmage", title="Articolo", type='str',
                           defvalue="",optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        d._push()
        d.field(name="magazino", title="Magazzino",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="tipo_operazione", title="Tipo'",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="q_ta_movmage", title="Quantita\'",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="prezzo_movmage", title="Prezzo",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        d._push()
        d.field(name="iva_mov_mage", title="IVA",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_oda", title="Ordine Acquisto",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="pos_oda", title="Posizione OdA",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        #### fine della scheda per movimenti di magazzino ###
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level



    def mod(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        # prende i dati da modificare dalla tabella fornitori
        #c.execute("SELECT * FROM movimenti_magazino WHERE id_movmage='" + a['id_movmage'] + "'")
        c.execute("SELECT * FROM movimenti_magazino WHERE id_movmage='" + a['id_movmage'] + "'")


        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!")
            

        d._push()
        d.ui(type="amwindow")
        d._push()
        # definisce l'azione del modulo/funzione con il il tipo
        d.dialog(action="magazzino/mod-db", type="mod")
        d._pop()

        # definisce il titolo della scheda
        
        d._push()
        d.title("Modifica Movimenti di Magazino")
        d._pop()

        # definisce il messaggio della scheda
        
        d._push()
        d.msg("Modifica il Movimenti di magazzino")
        d._push()
        #### inizio della sche per i movimenti di magazzino ###

        d._push()
        d.field(name="id_movmage", title="id", type='str',
                           defvalue=data['id_movmage'],optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="articolo_movmage", title="Articolo", type='str',
                           defvalue=data['articolo_movmage'],optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        d._push()
        d.field(name="magazino", title="Magazzino",  type='str',
                           defvalue=data['magazino'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="tipo_operazione", title="Tipo'",  type='str',
                           defvalue=data['tipo_operazione'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="q_ta_movmage", title="Quantita\'",  type='str',
                           defvalue=data['q_ta_movmage'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="prezzo_movmage", title="Prezzo",  type='str',
                           defvalue=data['prezzo_movmage'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()
        d._push()
        d.field(name="iva_mov_mage", title="IVA",  type='str',
                           defvalue=data['iva_mov_mage'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="numero_oda", title="Ordine Acquisto",  type='str',
                           defvalue=data['numero_oda'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="pos_oda", title="Posizione OdA",  type='str',
                           defvalue=data['pos_oda'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        
        #### fine della scheda per i fornitori ###
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level

    def add_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('articolo_movmage','magazino','q_ta_movmage','prezzo_movmage', 'iva_mov_mage','numero_oda','pos_oda')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = "INSERT INTO movimenti_magazino ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'
        print "movimenti_magazzino/add-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        #valuesl=('id_movmage','n_operazione','articolo_movmage','magazino','tipo_operazione','q_ta_movmage','prezzo_movmage','iva_mov_mage','numero_oda','pos_oda' )
        valuesl=('id_movmage','articolo_movmage','magazino','q_ta_movmage','prezzo_movmage', 'iva_mov_mage','numero_oda','pos_oda')
        
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        q = "UPDATE movimenti_magazino SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE id_movmage ='" + values['id_movmage'] + "'"
        
        print "clienti/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        q="DELETE FROM movimenti_magazino WHERE id_movmage='" +a['id_movmage'] + "'"
        c.execute (q)
        self.db.commit()
        
        print "magazzino/del: query: " + q

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    


    

