#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *


class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"Magazzino",be) # serve a identificare il nome mod

        self.gen()
        
        #self.addhandler("add",self.addmod,menu="Aggiungi")
        #self.addhandler("add-db",self.add_db)

        self.addhandler("del",self.del_db)

#        self.addhandler("prova",self.prova)
        
#    def prova(self,d,e):
#        a=e.attrib
#        print a
    
        
    def field_gen(self,x):
        ##name,title,type,defvalue,maxlen,optional,password,help,multiline,tooltip,ref,refname,refattrib
    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        x.addfield("id_movimento","id","int","",15,
                   False,None,"",False,"xx")
        x.addfield("data_movimento","Data Richiesta","date",self.be['dbutil'].oggi(),90,
                   False,None,"",False,"15-12-2006")
        x.addfield("codice_magazzino","Codice","str","",100,
                   False,None,"",False,"ART0001","articoli/list","codice")
        x.addfield("codice_mov_mage","Tipo Movimento","str","acq",100,
                   False,None,"",False,"yy")
        x.addfield("qta_acquisto","Quantita'","float","",2,
                   False,None,"",False,"12")
        
        
    def field_gen_ex(self,x):
        x.addfield("note_magazzino","Note aggiuntive","str"," ",0,
                   True,None,"",True,"")
        
    def gen(self):
        menuperfix="Acquisti/Approvigionamento"
        #aggiungi
        x=self.be['uiutil'].adddialog("Aggiungi","Inserire i dati per aggiungere un nuovo Approvigionamento","approvi/add-db")

        self.field_gen(x)
        self.field_gen_ex(x)
        
        self.addhandler("add",x.handle,menuprefix+"/Aggiungi")
        self.addhandler("add-db",self.add_db)

        # modifica
        x=self.be['uiutil'].moddialog("Modifica", "Modifica di un fornitore","approvi/mod-db",self.mod_sel)
        
        self.field_gen(x)
        self.field_gen_ex(x)
        self.addhandler("mod",x.handle,menuprefix+"/Modifica")
        self.addhandler("mod-db",self.mod_db)

        # listino
        x=self.be['uiutil'].listdialog("Lista fornitori","Lista fornitori", self.list_sel)

        self.field_gen(x)
        
        x.addcommand("approvi/add","Aggiungi","add",update="true")
        x.addcommand("approvi/mod","Modifica","edit",fwsel="id_movimento",update="true",doubleclick="true")
        x.addcommand("approvi/del","Rimuovi","delete",fwsel="id_movimento",update="true")
        #        x.addcommand("articoli/prova","Prova","prova",refattrib={'a':'pippo'})
#        x.addcommand("fornitori/report","Report","report")
#        self.addhandler("report",self.report)
        
        self.addhandler("list",x.handle,menuprefix+"/Lista Approv")
        
    def list_sel(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        c=self.db.cursor()
        c.execute("SELECT * FROM magazzino")
        
        data = c.dictfetchall()
        return data
    

    def mod_sel(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        c.execute("SELECT * FROM magazzino WHERE id_movimento = '" + a['id_movimento'] + "'")
        data = c.dictfetchone()
        
        if data is None: #bail out!!!
            raise Exception("Select call failed! Maybe the item does not exist")
        return data
    
    def add_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('data_movimento','codice_magazzino','codice_mov_mage','qta_acquisto','note_magazzino')
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = self.be['dbutil'].generate_insert_query("magazzino",values)
        
        print "fornitori/add-db: query: " + q
        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('id_movimento','data_movimento','codice_magazzino','codice_mov_mage','qta_acquisto','note_magazzino')
        
        
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        q = self.be['dbutil'].generate_update_query("magazzino",values,[("id_movimento","=",values['id_movimento'])])
        
        print "fornitori/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        
        c.execute ("DELETE FROM magazzino WHERE id_movimento='" +a['id_movimento'] + "'")
        self.db.commit()
        
        print "fornitori/del: query: "

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

