#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
             {'name':'data_movimento',
              'title':'Data Movimento',
              'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_magazzino',
             'title':'Codice Magazzino',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Articolo Movimentato',
             'ref':'articoli/list',
             'refname':'codice',
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"acq",
             'maxlen':15,
             'optional':False,
             'tooltip':'Articolo Movimentato',
             },

            {'name':'qta_carcico',
             'title':'Quantita',
             'type':'float',
             'defvalue':"",
             'maxlen':2,
             'optional':False,
             'tooltip':'Quantita Movimentata'
              },

            {'name':'prezzo_acquisto',
             'title':'Prezzo',
             'type':'float',
             'defvalue':"",
             'maxlen':2,
             'optional':False,
             'tooltip':'Pezzo Acquistato'
             },            
            {'name':'sconto_acquisto',
             'title':'Sconto Acquisto',
             'type':'float',
             'defvalue':"",
             'maxlen':2,
             'optional':False,
             'tooltip':'Aliquota Iva Vendita',
             },
            {'name':'codice_iva_pas',
             'title':'Iva Acquisto',
             'type':'float',
             'defvalue':"",
             'maxlen':2,
             'optional':True
            },
            {'name':'ordine_acquisto',
             'title':'Ordine Acquisto',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             },
            {'name':'ddt_carico_acq',
             'title':'DDT acquisto',
             'type':'str',
             'defvalue':"",
             'maxlen':20,
             'optional':False,
             'ref':'ddtfornitore/list',
             'refname':'n_f',
             },
            {'name':'fattura_acq',
             'title':'Fattura',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'ref':'fatturepas/list',
             'refname':'n_pas',
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'n'
             }


            ]
        
        simpledbmodule.__init__(self,name,"Acquisto",be,fields,delete=False,table="magazzino",menu="Acquisti/Acquisto???")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
