#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from module import *

class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,"Lavorazioni",be) # serve a identificare il nome mod
        
        self.addhandler("list",self.list,menu="Lista")
        self.addhandler("add",self.add,menu="Aggiungi")
        self.addhandler("add-db",self.add_db)
        self.addhandler("mod",self.mod)
        self.addhandler("mod-db",self.mod_db)
        self.addhandler("del",self.del_db)

    def list(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        d._push()
        d.ui(type="listview")
        # definisce il comando delete che modulo/funzione chiama con che valore
        d._push()
        d.command(stock="add",action="lavorazioni/add",update="true")
        d._pop()
        
        d._push()
        d.command(stock="edit",action="lavorazioni/mod",forwardselection="id_lavorazione",update="true",doubleclick="true")
        d._pop()
        
        d._push()
        d.command(stock="delete",action="lavorazioni/del",forwardselection="id_lavorazione",update="true")
        d._pop()
        
        d._pop()
        
        d._push()
        d.data(type="table")
        #headers
        d._push()
        d.headers()

        d._push()
        d.header(name="id_lavorazione", title="Codice",type="str") #....
        d._pop()

        d._push()
        d.header(name="codice_lavorazione", title="Codice",type="str") #....
        d._pop()

        d._push()
        d.header(name="cliente_lavorazione", title="cliente", type="str")
        d._pop()

        d._push()
        d.header(name="qta_lavorazioni", title="Quantita'", type="str")
        d._pop()

        d._pop() #headers

        d._push()
        d.rows()
        c=self.db.cursor()
        c.execute("SELECT * FROM lavorazioni")
        data = c.dictfetchall()
        for r in data:
            d._push()
            d.row(None,**r)
            d._pop()
        d._pop()

        d._pop()

        #at top level

    def add(self,d,e):
        a=e.attrib 

        
        d._push()
        d.ui(type="amwindow")
        d._push()
        # definisce l'azione del modulo/funzione con il il tipo
        d.dialog(action="lavorazioni/add-db", type="add")
        d._pop()

        d._push()
        d.title("Aggiungi Lavorazioni")
        d._pop()
        
        d._push()
        d.msg("Inserire i dati per aggiungere una nuova Lavorazione")
        d._push()
        #### inizio della scheda per gli articoli ###

        d._push()
        d.field(name="codice_lavorazione", title="Codice", type='str',
                           defvalue="",optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip',ref="viste/list_articoli",refname="codice")
        d._pop()
        
        d._push()
        d.field(name="cliente_lavorazione", title="Cliente",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="viste/list_clienti",refname="codice_cliente")
        d._pop()


        d._push()
        d.field(name="qta_lavorazioni", title="Quantita'",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')

        d._pop()
        
        d._push()
        d.field(name="prezzo_lavorazione", title="Prezzo Standard",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="data_reg_lavorazione", title="Data Registrazione",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="iva_lavorazioni", title="Aliquota IVA",  type='str',
                           defvalue="",optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="viste/list_codici_iva",refname="codice_iva")
        d._pop()

        d._push()
        d.field(name="note_lavorazioni", title="Note",  type='str',
                           defvalue="",optional=True,
                           help="Per andare a capo\\npremere Control+INVIO\\nPer passare all'elemento sucessivo premere CONTROL+TAB", multiline='True',
                           tooltip='Note aggiuntive')
        d._pop()

        #### fine della scheda per gli articoli ###
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level



    def mod(self,d,e):
        a=e.attrib 

        c=self.db.cursor()
        # prende i dati da modificare dalla tabella articoli
        c.execute("SELECT * FROM lavorazioni WHERE id_lavorazione='" + a['id_lavorazione'] + "'")
        data = c.dictfetchone()

        if data is None: #bail out!!!
            raise Exception("Select call failed!!")
            

        d._push()
        d.ui(type="amwindow")
        d._push()
        # definisce l'azione del modulo/funzione con il il tipo
        d.dialog(action="lavorazioni/mod-db", type="mod")
        d._pop()

        d._push()
        d.title("Modifica Lavorazione")
        d._pop()
        
        d._push()
        d.msg("Modifica i dati della Lavorazione")
        d._push()
        #### inizio della scheda per le lavorazioni ###

        d._push()
        d.field(name="id_lavorazione", title="Codice", type='str',
                           defvalue=data['id_lavorazione'],optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip',ref="viste/list_articoli",refname="codice")
        d._pop()

        d._push()
        d.field(name="codice_lavorazione", title="Codice", type='str',
                           defvalue=data['codice_lavorazione'],optional=False,
                           help='' ,
                           tooltip='Questo e\' un tooltip',ref="viste/list_articoli",refname="codice")
        d._pop()
        
        d._push()
        d.field(name="cliente_lavorazione", title="Cliente",  type='str',
                           defvalue=data['cliente_lavorazione'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="viste/list_clienti",refname="codice_cliente")
        d._pop()


        d._push()
        d.field(name="qta_lavorazioni", title="Quantita'",  type='str',
                           defvalue=data['qta_lavorazioni'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()


        d._push()
        d.field(name="prezzo_lavorazione", title="Prezzo Standard",  type='str',
                           defvalue=data['prezzo_lavorazione'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="data_reg_lavorazione", title="Data Registrazione",  type='str',
                           defvalue=data['data_reg_lavorazione'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip')
        d._pop()

        d._push()
        d.field(name="iva_lavorazioni", title="Aliquota IVA",  type='str',
                           defvalue=data['iva_lavorazioni'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="viste/list_codici_iva",refname="codice_iva")
        d._pop()

        d._push()
        d.field(name="protocollo_invc", title="Protocollo Fattura",  type='str',
                           defvalue=data['protocollo_invc'],optional=False,
                           help='',
                           tooltip='Questo e\' un tooltip',ref="fatture/list",refname="id_invc")
        d._pop()

        try:
            txt_note_lavorazioni=data['note_lavorazioni'].replace("\n","\\n")
        except:
            txt_note_lavorazioni=""

        d._push()
        d.field(name="note_lavorazioni", title="Note",  type='str',
                           defvalue=txt_note_lavorazioni,optional=True,
                           help="Per andare a capo\\npremere Control+INVIO\\nPer passare all'elemento sucessivo premere CONTROL+TAB", multiline='True',
                           tooltip='Note aggiuntive')
        d._pop()




        #### fine della scheda per gli articoli ###
        
        d._pop() # ui
        
        d._push()
        d.data()
        d._pop()
        
        

        #at top level

    def add_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('codice_lavorazione','cliente_lavorazione','cliente_lavorazione','qta_lavorazioni','prezzo_lavorazione','data_reg_lavorazione','iva_lavorazioni','note_lavorazioni')
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = "INSERT INTO lavorazioni ("
        for i in values.iterkeys():
            q+=i + ','    
        q=q[:-1]+') VALUES ('
        
        for i in values.itervalues():
            q+="'" + i + "'" + ","

        q=q[:-1]+')'
        print "lavorazioni/add-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    def mod_db(self,d,e):
        a=e.attrib 
        
        valuesl=('id_lavorazione','codice_lavorazione','cliente_lavorazione','cliente_lavorazione','qta_lavorazioni','prezzo_lavorazione','data_reg_lavorazione','iva_lavorazioni','note_lavorazioni','protocollo_invc')
        
        values={}
        for i in valuesl:
            values[i]=''

        for i in e.getchildren():
            if i.tag=='field':
                if values.has_key(i.attrib['name']):
                    values[i.attrib['name']]=i.attrib['value']
            else:
                print "Warning: unknown tag " + i.tag

        print values
        c = self.db.cursor()
        # definisce la tabella su cui aggiornare i dati
        q = "UPDATE lavorazioni SET "
        for k,v in values.iteritems():
            q+= k + '=' + "'" + v + "',"
        
        q=q[:-1]+" WHERE id_lavorazione ='" + values['id_lavorazione'] + "'"
        
        print "lavorazioni/mod-db: query: " + q

        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()


    def del_db(self,d,e):
        a=e.attrib 

        c = self.db.cursor()
        
        c.execute ("DELETE FROM lavorazioni WHERE codice='" +a['id_lavorazione'] + "'")
        self.db.commit()
        
        print "lavorazioni/del: query: "

        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

    


    

