
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             'fwvalue':'n'
             },
            {'name':'ordine_acquisto',
             'title':'N Ordine',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'fkey':'oda(id_oda)',
             'readonly':True,
             'fwvalue':'id_oda'
             },
            {'name':'data_movimento',
             'title':'Data Consegno',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"acq",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'fkey':'articoli(codice)',
             'readonly':True,
             },
            {'name':'qta_acquisto',
             'title':'Quantita Ordinata',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'ddt_carico_acq',
             'title':'Protocollo DDT',
             'type':'str',
             'defvalue':"",
             'maxlen':3,
             'optional':False,
             'ref':'ddtfornitore/list',
             'refname':'n_f',
             'tooltip':'Protocollo della DDT in Entrata'
             },
            {'name':'qta_carico',
             'title':'Quantita Arrivata',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':'Quanto materiale e\' arrivato'
             },
            {'name':'prezzo_acquisto',
             'title':'Prezzo Acquisto',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_acquisto',
             'title':'Sconto Acquisto',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_pas',
             'title':'Codice Iva',
             'type':'str',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'ref':'viste/list_aliq_iva',
             'refname':'aliquota',
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"ENT POS ODA",be,fields,delete=False,table="magazzino",menu="")

    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se ci sono per questa entrata c'è una ddt
        ## confermata se non ce ne sono permette la modifica dell'entrata
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT id_movimento, qta_acquisto, qta_carico, n_f, confermata FROM magazzino, ddt_fornitore WHERE id_movimento = '%s' AND n_f = ddt_carico_acq AND confermata='t'"% val)
        risl=len(c.fetchall())
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            # raise Exception(val + " id pos non ci sono righe ok") # test
            return False
        else:
            #raise Exception(val + " id pos ci sono righe ko") # test
            return True



    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['id_oda'])
        
        c.execute("SELECT * FROM magazzino WHERE ordine_acquisto='%s' AND codice_mov_mage='acq'" % val)
        
        data = c.dictfetchall()
    
        return data
