#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_oda',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'codice_forn_oda',
             'title':'Fornitore',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Fornitore',
             'ref':'persone/fornitori',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'data_oda',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Ordine Acquisto'
             },
            {'name':'note_oda',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Fattura Entrate Acquisto",be,fields,add=False,mod=False,delete=False,table="oda",menu="Acquisti/Fattura Entrate Ordini")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("odaentpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")


    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="odaentpos/list").attrib(ordine_acquisto=values['id_oda'])
        d._pop()

##     def leva_carico(self,d,e,values):
##         simpledbmodule.add_db_complete(self,d,e,values)
##         d._push()
##         d.redirect(action="odaentpos/list").attrib(ordine_acquisto=values['id_oda'])
##         d._pop()

