
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             'fwvalue':'n'
             },
            {'name':'fattura_acq',
             'title':'Fattura acquisto',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'fatturepas/list',
             'refname':'n_f',
             'fkey':'fatturepas(n_pas)',
             'readonly':True,
             'fwvalue':'n_pas'
             },
            {'name':'ddt_carico_acq',
             'title':'DDT carico acquisto',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'ddtfornitore/list',
             'refname':'n_f',
             'readonly':True,
             },
            {'name':'ordine_acquisto',
             'title':'N Ordine',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'oda/list',
             'refname':'id_oda',
             'fkey':'oda(id_oda)',
             'readonly':True,
             },
            {'name':'data_movimento',
             'title':'Data Entrata',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"acq",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'ref':'articoli/list',
             'refname':'codice,descrizione',
             'reftype':'combo',
             'fkey':'articoli(codice)',
             },
            {'name':'qta_acquisto',
             'title':'Quantita Ordinata',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'prezzo_acquisto',
             'title':'Prezzo Acquisto',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_acquisto',
             'title':'Sconto Acquisto',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_pas',
             'title':'Codice Iva',
             'type':'str',
             'defvalue':"20",
             'maxlen':3,
             'optional':False,
             'ref':'viste/list_aliq_iva',
             'refname':'codice_iva,descrizione',
             'reftype':'combo',
             'tooltip':''
             },
            
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"FATTURA FORNITORE POS",be,fields,delete=False,table="magazzino",menu="")

    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se la fattura passiva è registrata oppure no
        ## se non lo è ne permette la modifica dell'entrata
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT id_movimento, qta_acquisto, qta_carico, ddt_carico_acq, fattura_acq, registrata FROM magazzino, fatturepas WHERE n_pas=fattura_acq  AND registrata='t' AND id_movimento = '%s'  "% val)
        risl=len(c.fetchall())
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            # raise Exception(val + " id pos non ci sono righe ok") # test
            return False
        else:
            #raise Exception(val + " id pos ci sono righe ko") # test
            return True


    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n_pas'])
        
        c.execute("SELECT * FROM magazzino WHERE fattura_acq='%s' AND codice_mov_mage='acq'" % val)
        
        data = c.dictfetchall()
    
        return data
