
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n_pas',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'n_fattura_fornitore',
             'title':'Numero Fattura',
             'type':'str',
             'defvalue':"",
             'maxlen':10,
             'optional':False,
             'tooltip':'Numero indicato in Fattura',
             },
            {'name':'fornitore',
             'title':'Fornitore',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Fornitore',
             'ref':'persone/fornitori',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'data_pas',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data Fattura'
             },
            {'name':'scadenza',
             'title':'Scadenza',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'scadenza'
             },
            {'name':'note_pas',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Fatture Passive",be,fields,delete=False,table="fatturepas",menu="Acquisti/Fatture Passive")

        

    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("fatturepaspos/list","Gestisci posizioni",None,fwsel=self.key,update="true")
        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se ci sono righe in questa fattura passiva e
        ## non ce ne sono permette la modifica dell'ordine
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT id_movimento, qta_acquisto, qta_carico, ddt_carico_acq, fattura_acq FROM magazzino WHERE fattura_acq = '%s';" % val)
        risl=len(c.fetchall())
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            return False
        else:
            return True


    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="fatturepaspos/list").attrib(n_pas=values['n_pas'])
        d._pop()





## DECRYPTED
##     def list_sel(self,d,e):
##         c=self.db.cursor()
##         #val=self.be['dbutil'].escape_value(e.attrib['n'])
        
##         c.execute("SELECT * FROM fatturepas WHERE registrata = 't'" )
        
##         data = c.dictfetchall()
    
##         return data
