#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule 

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'cliente',
             'title':'Cliente',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Cliente',
             'ref':'persone/clienti',
             'refname':'codice',
             'fkey':'persone(codice)'
             },
            {'name':'data',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'scadenza',
             'title':'Scadenza',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'scadenza'
             },
            {'name':'registrata',
             'title':'Registrata',
             'type':'bool',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'tooltip':'Registra in Contabilita\''
             },
            {'name':'pagata',
             'title':'Pagata',
             'type':'bool',
             'defvalue':'false',
             'maxlen':0,
             'optional':True,
             'tooltip':'scadenza'
             },
##             {'name':'note',
##              'title':'Note aggiuntive',
##              'type':'str',
##              'defvalue':"",
##              'maxlen':0,
##              'optional':True,
##              'multiline':True,
##              'tooltip':'Note aggiuntive'
##              }
            ]
        
        
        simpledbmodule.__init__(self,name,"REGISTRA FATTURE",be,fields,add=False,delete=False,table="fatture",menu="Vendite/Registra Fatture")

        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se per questa fattura  la fattura esiste una
        ## riscossione se non lo è sono permette la modifica della riga
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT n, registrata, id_ric FROM fatture, riscossioni WHERE n='%s' AND n = id_ric" % val)
        dati_q=c.fetchall()
        risl=len(dati_q)
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            return False
        else:
            return True

    def list_sel(self,d,e):
        c=self.db.cursor()
        #val=self.be['dbutil'].escape_value(e.attrib['n'])
        
        c.execute("SELECT * FROM fatture ORDER BY n" )
        
        data = c.dictfetchall()
    
        return data


#    def gen_commands(self,x):
#        simpledbmodule.gen_commands(self,x)
#        x.addcommand("fatturepos/list","Vedi posizioni",None,fwsel=self.key,update="true")
