#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
#             'fwvalue':'id_movimento'
             },
            {'name':'fattura_ven',
             'title':'N Fattura',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
#             'ref':'fatture/list',
#             'refname':'n',
#             'fkey':'fatture(n)',
             'readonly':True,
             'fwvalue':'n'
             },
            {'name':'data_movimento',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"ven",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             'ref':'articoli/list',
             'refupdate':'prezzo_vendita:prezzo_std',
             'refname':'codice,descrizione',
             'reftype':'combo',
             #'refparam':''  TODO!!!! passa dei parametri alla risorsa
             'fkey':'articoli(codice)',
             },
            {'name':'qta_scarico',
             'title':'Quantita',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'prezzo_vendita',
             'title':'Prezzo Vendita',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_vendita',
             'title':'Sconto Vendita',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_atv',
             'title':'Codice Iva',
             'type':'str',
             'defvalue':"20",
             'maxlen':5,
             'optional':False,
             'readonly':True,
             'ref':'viste/list_aliq_iva',
             'refname':'codice_iva,descrizione',
             'reftype':'combo',
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"POS Fattura",be,fields,delete=False,table="magazzino",menu="",sort="id_movimento")

        self.mod_dialog.readonlycb=self.readonlycb
        self.add_dialog.handlehook=self.confermata

    def readonlycb(self,d,e):
        return self.be['fatture'].readonlycb(d,e)
    
    def confermata(self,d,e):
        if self.readonlycb(d,e):
            raise SoftException("Errore! La fattura e' gia' confermata!! Nessuna modifica consentita.")

    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n'])
        
        c.execute("SELECT * FROM magazzino WHERE fattura_ven='%s'" % val)
        
        data = c.dictfetchall()
    
        return data
