#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule 

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'cliente',
             'title':'Cliente',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Cliente',
             'ref':'persone/clienti',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'sconto',
             'title':'Sconto fattura',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':'Sconto',
             },
            {'name':'data',
             'title':'Data',
             'type':'date',
             'defvalue':lambda: be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'scadenza',
             'title':'Scadenza',
             'type':'date',
             'defvalue':lambda: be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'scadenza'
             },
            {'name':'pagata',
             'title':'pagata',
             'type':'bool',
             'defvalue':0,
             'maxlen':0,
             'optional':True,
             'tooltip':'pagata'
             },
            {'name':'note',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"FATTURE",be,fields,delete=False,table="fatture",menu="Vendite/Fatture")

        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        return False
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        if self.fattura_registrata(val):
            return True
        else:
            return False

    def registrata(self,d,e):
        if self.readonlycb(d,e):
            raise SoftException("Errore! la fattura e' gia' registrata")
        
    def gen(self):
        simpledbmodule.gen(self)
        x=self.be['uiutil'].adddialog('Associa DDT','Associa DDT',self.name+'/associaddt-db')
        x.addfield('n','N fattura','int','',fwvalue='n',readonly='true')
        x.addfield('cliente','Cliente','str','',fwvalue='cliente',readonly='true')
        x.addfield('ddt_n','DDT','int','',ref='ddt/list',refattrib={'nofatturato':'true'},refname='n_ddt',fwfields='cliente') # ,fwref='cliente'
        x.handlehook=self.registrata
        

	y=self.be['uiutil'].adddialog('Stampa lista','Stampa lista',self.name+'/stampalista-db')
        y.addfield('data1','Da data','date','')
        y.addfield('data2','A data','date',self.be['dbutil'].oggi())

        self.addhandler("associaddt",x.handle)
        self.addhandler("associaddt-db",self.associaddt_db)
        self.addhandler("stampa",self.stampa)
        self.addhandler("stampadebiti",self.stampadebiti)
        self.addhandler("stampalista",y.handle)
        self.addhandler("stampalista-db",self.stampalista)
        self.addhandler("registra",self.registra_db)
        
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("fatturepos/list","Vedi posizioni",None,fwsel=self.key,update="true")
        x.addcommand(self.name+"/associaddt","Associa DDT",None,fwsel='n,cliente',update="true")
        x.addcommand(self.name+"/registra",'Registra',None,fwsel='n',confirm="Sicuro di voler registrare la fattura? Nessuna modifica ulteriore sara' consentita",update="true")
        x.addcommand(self.name+"/stampa","Stampa fattura",None,fwsel='n')
        x.addcommand(self.name+"/stampadebiti","Stampa debiti",None)
        x.addcommand(self.name+"/stampalista","Stampa lista",None)	

    def gen_list(self):
        x=self.be['uiutil'].listdialog("Lista "+self.title,"", self.list_sel)

        x.addfield('n','N','int','')
        x.addfield('cliente','Cliente','str','')
        x.addfield('data','Data','date','')
        x.addfield('imponibile','Imponibile','float','',maxlen=3)
        x.addfield('iva','Iva','float','',maxlen=3)
        x.addfield('sconto','Sconto','float','',maxlen=3) 
        x.addfield('totale','Totale','float','',maxlen=3)
        x.addfield('registrata','Registrata','bool','')
        x.addfield('pagata','Pagata','bool','')
        
        self.gen_commands(x)
        if self.menuprefix is None:
            self.addhandler("list",x.handle)
        else:
            self.addhandler("list",x.handle,self.menuprefix+"/Lista")
        self.list_dialog=x

    def list_sel(self,d,e):
        a=e.attrib
        
        x=self.be['dbutil'].gen_filter_cond(['cliente'],a)

        if x != '':
            x=" WHERE " + x

        c=self.db.cursor()

        c.execute("SELECT * FROM fatture_view INNER JOIN fatture ON fatture.n=fatture_view.n ORDER BY fatture.n DESC" + x)
        
        data = c.dictfetchall()

        return data
    
    def fattura_registrata(self,n):
        #return False
        #controllo se la fattura e' registrata,
        c=self.db.cursor()
        c.execute("SELECT * FROM fatture WHERE n='%s'" % n)

        q=c.dictfetchone()
        print q['registrata']
        if q['registrata'] in ('t',True,'true','1','TRUE','True'):
            return True
        else:
            return False
        
    def assert_registrata(self,n):
        if not self.fattura_registrata(n):
            raise SoftException("Errore! la fattura non e' registrata!")
        
    def assert_non_registrata(self,n):
        if self.fattura_registrata(n):
            raise SoftException("Errore! la fattura e' gia' registrata!")

    def registra_db(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n'])

        c=self.db.cursor()

        #self.assert_non_registrata(n)

        c.execute ("SELECT * from magazzino WHERE fattura_ven='%s'"%n)
        fatt_pos=c.fetchall()
        
        if len(fatt_pos) ==0:
            raise SoftException("Errore: La fattura non puo' essere vuota!")

        c.execute("BEGIN")
        c.execute("UPDATE fatture set registrata='true' WHERE n='%s'"%n)
        c.execute("COMMIT")

        if not self.fattura_registrata(n):
            raise SoftException("Errore: la fattura non e' stata registrata")

        d._push()
        d.ui(type="message")
        d._pop()
        
        msg="Fattura %s Registrata." %n
        
        d._push()
        d.data(msg,type="text")
        d._pop()        
        

    def associaddt_db(self,d,e):
        values=self.be['dbutil'].cleanup_field_params(e,['n','cliente','ddt_n'])
        w={'fattura_ven':values['n']}

        c=self.db.cursor()

        self.assert_non_registrata(values['n'])
        
        ## controlliamo che nn sia gia registrata
        c.execute ("SELECT fattura_ven FROM magazzino \
                   WHERE ddt_vendita='%s' AND fattura_ven IS NOT NULL "
                   % values['ddt_n']
                   )
        boh=c.fetchone()
        
        if boh:
            raise SoftException("ERRORE! DDT #%s gia' associata alla fattura #%s"
                                % (values['ddt_n'],boh[0])
                                )

        #controlliamo che la DDT esista veramente:
        c.execute("SELECT conf from ddt WHERE n_ddt='%s'" % values['ddt_n'])
        boh=c.fetchone()
        if not boh:
            raise SoftException("ERRORE! numero DDT non valido!")
        
        #controlliamo che la DDT sia confermata:
        if not boh[0] in  ('t',True,'true','1','TRUE','True'):
            raise SoftException("ERRORE! il DDT deve prima essere confermato!")
    
        c.execute("BEGIN")

        q=self.be['dbutil'].generate_update_query(
            'magazzino',
            w,
            "ddt_vendita='%s'" % values['ddt_n']
            )

        c.execute(q)
        c.execute("""SELECT prezzo_std,id_movimento FROM magazzino,articoli \
                     WHERE codice_magazzino=codice AND ddt_vendita='%s'"""
                  % values['ddt_n']
                  )

        r=c.dictfetchall()

        for a in r:
            c.execute ("UPDATE magazzino SET prezzo_vendita='%s', \
                       codice_iva_atv='20',fattura_ven='%s' \
                       WHERE id_movimento='%s'"
                      % (a['prezzo_std'],values['n'],a['id_movimento'])
                      )
                   ## FIXME iva 20 default????
        c.execute("UPDATE ddt SET fattura='%s' WHERE n_ddt='%s'"%(values['n'],values['ddt_n']))
        c.execute("COMMIT")

        d._push()
        d.ui(type="message")
        d._pop()
        
        msg="DDT #"+str(values['ddt_n'])+" associato alla fattura #"+ str(values['n'])
        
        d._push()
        d.data(msg,type="text")
        d._pop()        


    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="fatturepos/list").attrib(n=values['n'])
        d._pop()

    def stampadebiti(self,d,e):
	q="select fatture.n as n ,fatture.cliente as cliente,fatture.data::date as data,imponibile::numeric(5,2) as imponibile,iva::numeric(5,2) as iva,totale::numeric(5,2) as totale from fatture_view,fatture where fatture.n=fatture_view.n and pagata='f';   "
	
	c=self.db.cursor()
	c.execute(q)
	s=" ====== Debiti clienti ======  al "+ self.be['dbutil'].oggi() +"\n\n"
	cols=[('n',4),('cliente',15),('data',10),('imponibile',10),('iva',7),('totale',7)]
	for i in cols:
		s+=(" | %%%is"%i[1]) % i[0]
	s+=" |"
	n=0
	for i in cols:
		n+=i[1]+3
	s+="\n"
	s+="-"*n+"\n"

	for i in c.dictfetchall():
		for f in cols:	
			v=str(i[f[0]])
			if f[0]=='data':
				v=v.split(" ")[0]
			s+=(" | %%%is"%f[1])% v
		s+="\n"

	s+="-"*n+"\n"

	q="select sum(imponibile)::numeric(10,2) as imponibile,sum(iva)::numeric(10,2) as iva,sum(totale)::numeric(10,2) as totale from fatture_view ,fatture where fatture.n=fatture_view.n and pagata='f';"
	

	c.execute(q)
	
        i=c.dictfetchone()

     	for f in cols:
		if i.has_key(f[0]):
                        v=str(i[f[0]])	
		else:
			v="" 
                if f[0]=='data':
                	v=v.split(" ")[0]
               	s+=(" | %%%is"%f[1])% v
      	s+="\n"

	#print s
#	os.system('echo "%s" | lpr' % s)

	d._push()
        d.ui(type="textview",fixed=True).title("Debiti Clienti")
	
        d._pop()

        d._push()
        d.data(s)
        d._pop()

    def stampalista(self,d,e):
	values=self.be['dbutil'].cleanup_field_params(e,['data1','data2'])
	
	q="select fatture.n as n , pagata ,fatture.cliente as cliente,fatture.data::date as data,imponibile::numeric(5,2) as imponibile,iva::numeric(5,2) as iva,totale::numeric(5,2) as totale from fatture_view,fatture where fatture.n=fatture_view.n and (fatture.data between '%s' and '%s'); " % (values['data1'],values['data2'])
	
	c=self.db.cursor()
	c.execute(q)
	s=" ====== Fatture clienti ======  dal "+ values ['data1'] + " al "+ values['data2'] + "\n\n"
	cols=[('n',4),('cliente',15),('data',10),('imponibile',10),('iva',7),('totale',7),('pagata',7)]
	for i in cols:
		s+=(" | %%%is"%i[1]) % i[0]
	s+=" |"
	n=0
	for i in cols:
		n+=i[1]+3
	s+="\n"
	s+="-"*n+"\n"

	for i in c.dictfetchall():
		for f in cols:	
			v=str(i[f[0]])
			if f[0]=='data':
				v=v.split(" ")[0]
			s+=(" | %%%is"%f[1])% v
		s+="\n"

	s+="-"*n+"\n"

	q="select sum(imponibile)::numeric(10,2) as imponibile,sum(iva)::numeric(10,2) as iva,sum(totale)::numeric(10,2) as totale from fatture_view ,fatture where fatture.n=fatture_view.n and (fatture.data between '%s' and '%s'); " % (values['data1'],values['data2'])
	
	c.execute(q)
	
        i=c.dictfetchone()

     	for f in cols:
		if i.has_key(f[0]):
                        v=str(i[f[0]])	
		else:
			v="" 
                if f[0]=='data':
                	v=v.split(" ")[0]
               	s+=(" | %%%is"%f[1])% v
      	s+="\n"

#	print s
#	os.system('echo "%s" | lpr' % s)

	d._push()
        d.ui(type="textview",fixed=True).title("Debiti Clienti")
	
        d._pop()

        d._push()
        d.data(s)
        d._pop()

    def stampa(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n'])

        self.assert_registrata(n)

        q="SELECT * FROM fatture WHERE n='%s'" % n

        c=self.db.cursor()
        c.execute(q)
        dati_fatt=c.dictfetchone()
        
        c.execute("SELECT * from fatture_view WHERE n='%s'" % n)
        totali_fatt=c.dictfetchone()
	
	q="SELECT DISTINCT ddt_vendita from magazzino WHERE fattura_ven='%s' order by ddt_vendita"%n
	c.execute(q)
        ddt_assoc=c.dictfetchall()

	fatt_pos=[]

	for ddt in ddt_assoc:
		r="AND ddt_vendita is NULL"
	
		if ddt['ddt_vendita'] is not None:
			r="AND ddt_vendita='%s'" % ddt['ddt_vendita']
			
        	q="""SELECT codice, articoli.descrizione, qta_scarico as qta,  \
	        prezzo_vendita as prezzo, sconto_vendita as sconto,   \
	        aliquota as iva, um,                                  \
        	(prezzo_vendita*(1-sconto_vendita/100)*qta_scarico) as importo \
	        FROM magazzino,articoli,codici_iva                    \
        	WHERE codice_iva='20'                                 \
	        AND codice_magazzino=codice                           \
        	AND fattura_ven='%s'  %s""" % (n,r)
        	
	        c.execute(q)
	
		w=c.dictfetchall()
	       	
	        l=['prezzo','sconto','importo']
        	for i,u in enumerate(w):
	            	for k in l:
        	        	w[i][k]="%.2f"%w[i][k]
	
		if ddt['ddt_vendita'] is not None:

			q="SELECT data from ddt where n_ddt='%s'"%ddt['ddt_vendita']
			c.execute(q)
			y=c.dictfetchone()
		
			fatt_pos+=[{'descrizione':'In rif. al DDT n. %s del %s:' % (ddt['ddt_vendita'],y['data'])
					,'prezzo':'','codice':'','qta':'','sconto':'','iva':'','um':'','importo':''}]

		fatt_pos+=w
        
	q="SELECT * FROM clienti WHERE codice='%s'"%dati_fatt['cliente']
        c.execute(q)

	if len(fatt_pos)==0:	
		raise SoftException("Errore: La fattura non puo' essere vuota! Errore di inconsistenza nel DB! Contattare l'amministratore del sistema")
        	

        dati_cli=c.dictfetchone()

        dati_azienda=self.be['dbutil'].fetch_config()
        
        n="%04i"%(self.be['dbutil'].extractn(n))
        
        f={'tipo':'FATTURA',
           'n':n,
           'codcliente':dati_fatt['cliente'],
           'cliente':dati_cli['nome'],
           'indcliente':dati_cli['indirizzo'],
           'cittacliente':str(dati_cli['cap'])+" "+dati_cli['citta'],
           'notecliente':dati_cli['note'],
           'pivacliente':dati_cli['pi'],
           'data':self.be['dbutil'].italian_date(dati_fatt['data']),
           'abcde1231': ('limits','row',fatt_pos),
           'imponibile':"%.2f"%totali_fatt['imponibile'],
           'totale_iva':"%.2f"%totali_fatt['iva'],
           'totale':"%.2f"%totali_fatt['totale'],
           'sconto_fattura':"%.2f"%totali_fatt['sconto'],
           
           'azienda': dati_azienda['nome_azienda'],
           'piva':dati_azienda['piva_azienda'],
           'citta':dati_azienda['citta_azienda'],
           'indirizzo':dati_azienda['indirizzo_azienda'],
           'tel':dati_azienda['tel_azienda'],
           'fax':dati_azienda['fax_azienda'],
           'logo':dati_azienda['logo_azienda'],
           'note1':dati_fatt['note'],
           'note2':'',
           'note3':'',
           'note4':''
           }
        
        x=self.be['svg'].renderpdf("fattura.svg",f,2 )
       
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()
        
        d.data("<![CDATA["+b2a_base64(x)+"]]>",format="pdf")
        d._pop()

