#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'autokey':True,
             'fwvalue':'n'
             },
            {'name':'ddt_carico_acq',
             'title':'DDT carico acquisto',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'ddtfornitore/list',
             'refname':'n_f',
             'fkey':'ddt_fornitore(n_f)',
             'readonly':True,
             'fwvalue':'n_f'
             },
            {'name':'ordine_acquisto',
             'title':'N Ordine',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'oda/list',
             'refname':'id_oda',
             'fkey':'oda(id_oda)',
             'readonly':True,
             },
            {'name':'data_movimento',
             'title':'Data Entrata',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"acq",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'ref':'articoli/list',
             'refname':'codice',
             'fkey':'articoli(codice)',
             },
            {'name':'qta_acquisto',
             'title':'Quantita Ordinata',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'prezzo_acquisto',
             'title':'Prezzo Acquisto',
             'type':'float',
             'defvalue':"0",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'sconto_acquisto',
             'title':'Sconto Acquisto',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'codice_iva_pas',
             'title':'Codice Iva',
             'type':'int',
             'defvalue':"20",
             'maxlen':3,
             'optional':False,
             'ref':'viste/list_aliq_iva',
             'refname':'aliquota',
             'tooltip':''
             },
            
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"DDT FORNITORE POS",be,fields,add=True,mod=True,delete=False,table="magazzino",menu="")


    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n_f'])
        
        c.execute("SELECT * FROM magazzino WHERE ddt_carico_acq='%s' AND codice_mov_mage='acq'" % val)
        
        data = c.dictfetchall()
    
        return data
