#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n_f',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True,
             },
            {'name':'numero_ddt_for',
             'title':'Numero DTT',
             'type':'str',
             'defvalue':"",
             'maxlen':10,
             'optional':False,
             'tooltip':'Numero DDT indicato in DDT',
             },
            {'name':'fornitore',
             'title':'Fornitore',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Fornitore',
             'ref':'persone/fornitori',
             'refname':'codice',
             },
            {'name':'data_f',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'confermata',
             'title':'Confermata',
             'type':'bool',
             'defvalue':"False",
             'maxlen':0,
             'tooltip':'Confermata'
             },
            {'name':'note_f',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"DDT Fornitore",be,fields,delete=False,table="ddt_fornitore",menu="Acquisti/DDT")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)

        x.addcommand("ddtforpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")

        ## richiamiamo il controllo per la form modifica in solo lettura
        self.mod_dialog.readonlycb=self.readonlycb

    def readonlycb(self,d,e):
        ## effettua il controllo se ci sono righe in questa ddt fornitore  e se
        ## non ce ne sono permette la modifica dell'ordine
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a[self.key])
        c.execute("SELECT id_movimento, qta_acquisto, qta_carico, ddt_carico_acq, fattura_acq FROM magazzino WHERE ddt_carico_acq = '%s' AND fattura_acq is not null" % val)
        risl=len(c.fetchall())
        ## se non ci sono righe permette la scrittura
        if risl == 0:
            return False
        else:
            return True

    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="ddtforpos/list").attrib(n_f=values['n_f'])
        d._pop()
