#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n_f',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True,
             },
            {'name':'numero_ddt_for',
             'title':'Numero DTT',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':False,
             'tooltip':'Numero DDT indicato in DDT',
             },
            {'name':'fornitore',
             'title':'Fornitore',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Fornitore',
             'ref':'persone/fornitori',
             'refname':'codice',
             },
            {'name':'data_f',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'confermata',
             'title':'Confermata',
             'type':'bool',
             'defvalue':"False",
             'maxlen':0,
             'tooltip':'Confermata'
             },
            {'name':'note_f',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"DDT Fornitore Confermate",be,fields,add=False,delete=False,table="ddt_fornitore",menu="Acquisti/DDT da fatturare")
    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)

        x.addcommand("ddtforfatacqpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")

    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="ddtforfatacqpos/list").attrib(ddt_carico_acq=values['n_f'])
        d._pop()

    def list_sel(self,d,e):
        c=self.db.cursor()
        #val=self.be['dbutil'].escape_value(e.attrib['n'])
        
        c.execute("SELECT * FROM ddt_fornitore WHERE confermata = 't'" )
        
        data = c.dictfetchall()
    
        return data
