
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'id_movimento',
             'title':'ID',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'ID',
             'readonly':True,
             'autokey':True,
             },
            {'name':'ddt_vendita',
             'title':'N. DDT',
             'type':'int',
             'defvalue':'',
             'maxlen':0,
             'optional':False,
             'tooltip':'',
             'ref':'ddt/list',
             'refname':'n_ddt',
             'fkey':'ddt(n_ddt)',
             'readonly':True,
             'fwvalue':'n_ddt'
             },
            {'name':'data_movimento',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'codice_mov_mage',
             'title':'Tipo Movimento',
             'type':'str',
             'defvalue':"ven",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'readonly':True,
             },
            {'name':'codice_magazzino',
             'title':'Articolo',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'',
             'ref':'articoli/list',
             'refname':'codice',
             'fkey':'articoli(codice)',
             },
            {'name':'qta_scarico',
             'title':'Quantita',
             'type':'float',
             'defvalue':"1",
             'maxlen':3,
             'optional':False,
             'tooltip':''
             },
            {'name':'note_magazzino',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"POS DDT",be,fields,delete=False,table="magazzino",menu="")

        self.mod_dialog.readonlycb=self.readonlycb
        self.add_dialog.handlehook=self.confermato
        c=self.list_dialog.getcommand(self.name+"/add")
        c.fwparam="n_ddt"
        
    def confermato(self,d,e):
        if self.be['ddt'].readonlycb(d,e):
            raise SoftException("Errore! Il ddt e' gia' confermato!! Nessuna modifica consentita.")
        
    def gen(self):
        simpledbmodule.gen(self)
        x=self.be['uiutil'].listdialog('Preventivi','Preventivi',self.prev_sel)
        x.addfield('n_prev_ven','Numero Preventivo','int','',fwvalue='n_prev_ven',readonly='true')
        x.addfield('data_prev_ven','Data','date','',fwvalue='data_prev_ven',readonly='true')

        self.addhandler("prev",x.handle)

        x.addcommand(self.name+"/posprev","Seleziona",None,doubleclick=True,fwsel="n_prev_ven",fwparam='n_ddt',update="true")
        x.handlehook=self.confermato

        x=self.be['uiutil'].listdialog('Posizioni preventivo','Seleziona il prodotto',self.posprev_sel)
        x.addfield('id_movimento','ID','int','',fwvalue='id_movimento',readonly='true')
        x.addfield('codice_magazzino','Articolo','str','',fwvalue='codice_magazzino',readonly='true')
        x.addfield('qta_prev_ven','Qta','float','',fwvalue='qta_prev_ven')
        self.addhandler("posprev",x.handle)
        x.addcommand(self.name+"/addposprev","Seleziona",None,doubleclick=True,fwparam="n_prev_ven,n",fwsel='id_movimento,codice_magazzino,qta_prev_ven',update="true")


        x=self.be['uiutil'].adddialog('Agg. Prev. DDT','Aggiungi pos preventivo in DDT',
                                      self.name+"/addposprev-db")
        x.addfield('n_ddt','N. DDT','int','',fwvalue='n',readonly='true')
        x.addfield('n_prev_ven','N. Preventivo','int','',fwvalue='n_prev_ven',readonly='true')
        x.addfield('id_movimento','ID','int','',fwvalue='id_movimento',readonly='true')
        x.addfield('codice_magazzino','Articolo','str','',fwvalue='codice_magazzino',readonly='true')
        x.addfield('qta_prev_ven','Qta','float','',fwvalue='qta_prev_ven')
        
        self.addhandler("addposprev",x.handle)
        self.addhandler("addposprev-db",self.addposprev_db)


    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand(self.name+"/prev","Aggiungi da preventivo",None,fwparam="n_ddt,cliente,n",update="true")        

    def prev_sel(self,d,e):
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a['cliente'])
        q="SELECT * FROM preventivi_ven WHERE confermato AND cliente_prev_ven='%s'  ORDER BY n_prev_ven DESC" % val
        c.execute(q)
#        raise SoftException(q)
        t= c.dictfetchall()
        u=[]
        for a in t:
            c.execute("SELECT COUNT(*) FROM magazzino WHERE preventivo='%s' AND ddt_vendita is NULL" %a['n_prev_ven'])
            x=c.fetchone()
            if x[0] != 0:
                u.append(a)
        return u
    
    def posprev_sel(self,d,e):
        a=e.attrib
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(a['n_prev_ven'])
        c.execute("SELECT * FROM magazzino INNER JOIN preventivi_ven ON (preventivo=n_prev_ven) WHERE preventivo='%s' AND confermato AND ddt_vendita is NULL ORDER BY preventivo" % val)
        return c.dictfetchall()

    def addposprev_db(self,d,e):
        values=self.be['dbutil'].cleanup_field_params(e,['n_prev_ven','n_ddt','id_movimento','qta_prev_ven','codice_magazzino'])
        v = {
            'ddt_vendita':values['n_ddt'],
            'qta_scarico':values['qta_prev_ven']
            }
        c=self.db.cursor()

        q=self.be['dbutil'].generate_update_query('magazzino',v,"id_movimento='%s'"%values['id_movimento'])
        
        c.execute("BEGIN")
        c.execute(q)
        c.execute("COMMIT")
        
        d._push()
        d.ui(type="message")
        d._pop()
        
        msg = "Articolo %s del preventivo #%s associato al DDT #%s" % (values['codice_magazzino'],values['n_prev_ven'],values['n'])
        
        d._push()
        d.data(msg,type="text")
        d._pop()

    def posddt_confermata(self,mov):
        q="SELECT ddt_vendita FROM magazzino WHERE id_movimento='%s'"%mov
        c=self.db.cursor()
        c.execute(q)
        a=c.fetchone()
        return self.be['ddt'].ddt_confermato(a[0]
)
        
    def readonlycb(self,d,e):
        val=self.be['dbutil'].escape_value(e.attrib[self.key])
        return self.posddt_confermata(val)
    
    def list_sel(self,d,e):
        c=self.db.cursor()
        val=self.be['dbutil'].escape_value(e.attrib['n_ddt'])
        
        c.execute("SELECT * FROM magazzino WHERE ddt_vendita='%s'" % val)
        
        data = c.dictfetchall()
    
        return data
