
#! /usr/bin/python

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'cliente',
             'title':'Cliente',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Cliente',
             'ref':'persone/clienti',
             'refname':'codice',
             'fkey':'persone(codice)'
             },
            {'name':'data',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'interna',
             'title':'Internal',
             'type':'bool',
             'defvalue':"True",
             'maxlen':0,
             'tooltip':'Se e\' solo ad uso interno'
             },
            {'name':'nome_vettore',
             'title':'Nome Vettore',
             'type':'str',
             'defvalue':"",
             'maxlen':100,
             'optional':True,
             'tooltip':'Nome vettore'
             },
            {'name':'indirizzo_vettore',
             'title':'Indirizzo Vettore',
             'type':'str',
             'defvalue':"None",
             'maxlen':100,
             'optional':True,
             'tooltip':'Indirizzo del Vettore'
             },
            {'name':'citta_vettore',
             'title':'Citta\' Vettore',
             'type':'str',
             'defvalue':"None",
             'maxlen':100,
             'optional':True,
             'tooltip':'Citta del Vettore'
             },
            {'name':'numero_colli',
             'title':'Numero Colli',
             'type':'str', ## attenzione non viene visualizzato
             'defvalue':"0",
             'maxlen':0,
             'optional':True,
             'tooltip':'Numero dei colli'
             },
            {'name':'aspetto_colli',
             'title':'Aspetto Colli',
             'type':'str',
             'defvalue':"None",
             'maxlen':100,
             'optional':True,
             'tooltip':'Aspetto dei colli'
             },
            {'name':'conf',
             'title':'Confermata',
             'type':'bool',
             'defvalue':'False',
             'optional':True,
             'tooltip':'Se la DDT e\' Confermata'
             },
            {'name':'note',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"DDT non Confermate",be,fields,add=False,mod=False,delete=False,table="ddt",menu="")

    # seleziona le ddt che non sono state confermate
    def list_sel(self,d,e):
        c=self.db.cursor()
        c.execute("SELECT * FROM ddt WHERE conf='f'")
        data = c.dictfetchall()
    
        return data


    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("ddtpos/list","Gestisci posizioni",None,fwsel=self.key,update="true")

    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="ddtpos/list").attrib(n=values['n'])
        d._pop()
