#! /usr/bin/python
# -*- coding: iso-8859-1 -*-

# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be,version=0.1):

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'n_ddt',
             'title':'Numero',
             'type':'int',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Numero progressivo',
             'autokey':True
             },
            {'name':'cliente',
             'title':'Cliente',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'tooltip':'Cliente',
             'ref':'persone/clienti',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'data',
             'title':'Data',
             'type':'date',
             'defvalue':be['dbutil'].oggi(),
             'maxlen':0,
             'optional':False,
             'tooltip':'Data DDT'
             },
            {'name':'interna',
             'title':'Internal',
             'type':'bool',
             'defvalue':"False",
             'maxlen':0,
             'tooltip':'Se e\' solo ad uso interno'
             },
            {'name':'causale',
             'title':'Causale di trasporto',
             'type':'str',
             'defvalue':"Reso lavorato",
             'maxlen':50,
             'optional':False,
             'tooltip':'Causale di trasporto'
             },	 
            {'name':'nome_vettore',
             'title':'Nome Vettore',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':True,
             'tooltip':'Nome vettore'
             },
            {'name':'indirizzo_vettore',
             'title':'Indirizzo Vettore',
             'type':'str',
             'defvalue':"None",
             'maxlen':50,
             'optional':True,
             'tooltip':'Indirizzo del Vettore'
             },
            {'name':'citta_vettore',
             'title':'Citta\' Vettore',
             'type':'str',
             'defvalue':"None",
             'maxlen':50,
             'optional':True,
             'tooltip':'Citta del Vettore'
             },
            {'name':'numero_colli',
             'title':'Numero Colli',
             'type':'int', ## attenzione non viene visualizzato
             'defvalue':"1",
             'maxlen':0,
             'optional':True,
             'tooltip':'Numero dei colli'
             },
            {'name':'aspetto_colli',
             'title':'Aspetto Colli',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'optional':True,
             'tooltip':'Aspetto dei colli'
             },
            {'name':'note',
             'title':'Note aggiuntive',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Note aggiuntive'
             }
            ]
        
        simpledbmodule.__init__(self,name,"DDT",be,fields,delete=False,table="ddt",menu="Vendite/DDT")

        self.mod_dialog.readonlycb=self.readonlycb
        self.addhandler("conferma",self.conferma_db)
        self.addhandler("stampa",self.stampa)

    def gen_list(self):
        x=self.be['uiutil'].listdialog("Lista "+self.title,"", self.list_sel)

        x.addfield('n_ddt','N','int','')
        x.addfield('cliente','Cliente','str','')
        x.addfield('data','Data','date','')
        x.addfield('conf','Confermato','bool','')
        x.addfield('interna','Interna','bool','')
        x.addfield('fattura','Fattura','int','')
        
        self.gen_commands(x)
        if self.menuprefix is None:
            self.addhandler("list",x.handle)
        else:
            self.addhandler("list",x.handle,self.menuprefix+"/Lista")
        self.list_dialog=x

    def readonlycb(self,d,e):
        val=self.be['dbutil'].escape_value(e.attrib[self.key])

        return self.ddt_confermato(val)
            
    def ddt_confermato(self,n):
        #controllo se il ddt e' confermato,
        c=self.db.cursor()
        c.execute("SELECT * FROM ddt WHERE n_ddt='%s'" % n)

        q=c.dictfetchone()
        print q['conf']
        if q['conf'] in ('t',True,'true','1','TRUE','True'):
            return True
        else:
            return False
        
    def assert_confermato(self,n):
        if not self.ddt_confermato(n):
            raise SoftException("Errore! il DDT non e' confermato!")
        
    def assert_non_confermato(self,n):
        if self.ddt_confermato(n):
            raise SoftException("Errore! il DDT e' gia' confermato!")

    ## seleziona tutte le ddt
    def list_sel(self,d,e):
        a=e.attrib
        
        x=self.be['dbutil'].gen_filter_cond(['cliente'],a)

        if a.has_key('nofatturato'):
            x+=" AND fattura IS NULL "
        
        if x != '':
            x=" WHERE " + x

        c=self.db.cursor()
        c.execute("SELECT * FROM ddt "  + x + " ORDER BY n_ddt DESC")
        data = c.dictfetchall()

        return data


    def gen_commands(self,x):
        simpledbmodule.gen_commands(self,x)
        x.addcommand("ddtpos/list","Gestisci posizioni",None,fwsel=self.key+",cliente",update="true")
        x.addcommand(self.name+"/conferma","Conferma DDT",None,fwsel=self.key,update="true",confirm="Sicuro di voler confermare la DDT? Nessuna modifica ulteriore verra' consentita")
        x.addcommand(self.name+"/stampa","Stampa DDT",None,fwsel='n_ddt')
        
    def add_db_complete(self,d,e,values):
        simpledbmodule.add_db_complete(self,d,e,values)
        d._push()
        d.redirect(action="ddtpos/list").attrib(n_ddt=values['n_ddt'],cliente=values['cliente'])
        d._pop()

    def conferma_db(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n_ddt'])

        c=self.db.cursor()

        self.assert_non_confermato(n)

        c.execute ("SELECT * from magazzino WHERE ddt_vendita='%s'"%n)
        ddt_pos=c.fetchall()
        
        if len(ddt_pos) ==0:
#            raise SoftException("Errore: Il DDT non puo' essere vuoto! Che ti e' saltato in mente?!\nE' meglio se cambi lavoro vai a zappare i campi!")
            raise SoftException("Errore: Il DDT non puo' essere vuoto!")
        c.execute("BEGIN")
        c.execute("UPDATE ddt set conf='true' WHERE n_ddt='%s'"%n)
        c.execute("COMMIT")

        if not self.ddt_confermato(n):
            raise SoftException("Errore: il DDT non e' stato confermato")

        d._push()
        d.ui(type="message")
        d._pop()
        
        msg="DDT #%s confermato." %n
        
        d._push()
        d.data(msg,type="text")
        d._pop()        

    def stampa(self,d,e):
        n=self.be['dbutil'].escape_value(e.attrib['n_ddt'])
        
        self.assert_confermato(n)

        q="SELECT * FROM ddt WHERE n_ddt='%s'" % n

        c=self.db.cursor()
        c.execute(q)
        dati_ddt=c.dictfetchone()
        
        q="""SELECT codice, articoli.descrizione, qta_scarico as qta, um  \
        FROM magazzino,articoli                                           \
        WHERE codice_magazzino=codice                                     \
        AND ddt_vendita='%s'""" % n
        
        c.execute(q)
        ddt_pos = c.dictfetchall()
             
        q="SELECT * FROM clienti WHERE codice='%s'"%dati_ddt['cliente']
        c.execute(q)
        dati_cli=c.dictfetchone()

        q="SELECT * FROM config"
        c.execute(q)

        dati_azienda={}
        x=c.dictfetchall()
        for a in x:
            dati_azienda[a['nome']]=a['valore']
        
        n="%04i"%(self.be['dbutil'].extractn(n))
	causale=dati_ddt['causale']
	if causale is None:
	   causale='-'

        f={'tipo':'DOCUMENTO DI TRASPORTO',
           'n':n,
           'codcliente':dati_ddt['cliente'],
           'cliente':dati_cli['nome'],
           'indcliente':dati_cli['indirizzo'],
           'cittacliente':str(dati_cli['cap'])+" "+dati_cli['citta'],
           'notecliente':dati_cli['note'],
           'pivacliente':dati_cli['pi'],
           'data':self.be['dbutil'].italian_date(dati_ddt['data']),
           'dest':dati_cli['nome'],
           'inddest':dati_cli['indirizzo'],
           'cittadest':str(dati_cli['cap'])+" "+dati_cli['citta'],
           'notedest':dati_cli['note'],
	
	   'causale':causale,
	   'colli':dati_ddt['numero_colli'],

           'abcde1231': ('limits','row',ddt_pos),

           'azienda': dati_azienda['nome_azienda'],
           'piva':dati_azienda['piva_azienda'],
           'citta':dati_azienda['citta_azienda'],
           'indirizzo':dati_azienda['indirizzo_azienda'],
           'tel':dati_azienda['tel_azienda'],
           'fax':dati_azienda['fax_azienda'],
           'logo':dati_azienda['logo_azienda'],
           'note':dati_ddt['note'],
           }
        
        x=self.be['svg'].renderpdf("ddt.svg",f,2)
        
       
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()
        
        d.data("<![CDATA["+b2a_base64(x)+"]]>",format="pdf")
        d._pop()
