#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *


class handler(module):
    def __init__(self,name,be):
        module.__init__(self,name,None,be) # serve a identificare il nome mod

        self.gen()
        
    def field_gen_iva(self,x):
        ##name,title,type,defvalue,maxlen,optional,password,help,multiline,tooltip,ref,refname,refattrib
    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        x.addfield("codice_iva","Codice","str","",5,
                   False,None,"",False,"Esempio: 20")
        x.addfield("aliquota","Aliquota","float","",2,
                   False,None,"",False,"Percentuale")
        x.addfield("descrizione","Descrizione","str","",100,
                   False,None,"",False)

    def gen(self):
        #aggiungi
        x=self.be['uiutil'].adddialog("Aggiungi","Inserire i dati per aggiungere un Codice IVA","contabilita/add-iva-db")

        self.field_gen_iva(x)
        
        self.addhandler("add-iva",x.handle,"Aggiungi")
        self.addhandler("add-iva-db",self.add_iva_db)
        # listino
        x=self.be['uiutil'].listdialog("Codici IVA","Lista Codici IVA", self.list_iva_sel)
        self.field_gen_iva(x)
        
        x.addcommand("contabilita/add-iva","Aggiungi","add",update="true")
        
        self.addhandler("list-iva",x.handle,"Codici IVA")
        
    def list_iva_sel(self,d,e):
        a=e.attrib ## check also parameters like search or paging

        c=self.db.cursor()
        c.execute("SELECT * FROM codici_iva")
        
        data = c.dictfetchall()
        return data
    
    def add_iva_db(self,d,e):
        a=e.attrib 
        # definisce quali campi si passa ad db
        valuesl=('codice_iva','aliquota','descrizione')
        values=self.be['dbutil'].cleanup_field_params(e,valuesl)
        
        c = self.db.cursor()
        # definisce la tabella su cui inserire i dati
        q = self.be['dbutil'].generate_insert_query("codici_iva",values)
        
        print "contabilita/add-db: query: " + q
        
        c.execute (q)
        self.db.commit()
        
        d._push()
        d.ui(type="message")
        d._pop()

        d._push()
        d.data("Operazione eseguita",type="text")
        d._pop()

        #at top level

        
