#! /usr/bin/python

# Copyright (C) 2005 Cristian Greggio
# Copyright (C) 2006 Aldo Nicolas Bruno

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from module import *

from util.ui import simpledbmodule

class handler(simpledbmodule):
    def __init__(self,name,be):
        

    ##attenzione il primo elemento verra usato come riferimento fisso x la modifica
        fields=[
            {'name':'codice',
             'title':'Codice',
             'type':'str',
             'defvalue':"",
             'maxlen':15,
             'optional':False,
             'password':None,
             'help':"",
             'multiline':False,
             'tooltip':'Es.: Art223'
             },
            {'name':'descrizione',
             'title':'Descrizione',
             'type':'str',
             'defvalue':"",
             'maxlen':50,
             'tooltip':'Descrizione breve'
             },
            {'name':'um',
             'title':'UM',
             'type':'str',
             'defvalue':"n",
             'maxlen':4,
             'tooltip':'Unita\' di misura',
             'ref':'articoli-um/list',
             'refname':'codice',
             'refname':'codice,descrizione',
             'reftype':'combo',
             'fkey':'articoli_um(codice)'
             },
            {'name':'tipo',
             'title':'Tipo',
             'type':'str',
             'defvalue':"con",
             'maxlen':10,
             'tooltip':'Tipo articolo',
             'ref':'articoli-tipi/list',
             'refname':'codice',
             'refname':'codice,descrizione',
             'reftype':'combo',
             'fkey':'articoli_tipi(codice)'
             },
            {'name':'prezzo_std',
             'title':'Prezzo Standard',
             'type':'float',
             'defvalue':"0.0",
             'maxlen':3,
             'tooltip':'Prezzo standard (di riferimento)'
             },
            {'name':'cod_fornitore',
             'title':'Codice fornitore',
             'type':'str',
             'defvalue':"F001",
             'maxlen':15,
             'tooltip':'Fornitore Abituale',
             'ref':'persone/fornitori',
             'refname':'codice,nome',
             'reftype':'combo',
             'fkey':'persone(codice)'
             },
            {'name':'punto_riordino',
             'title':'Punto riordino',
             'type':'float',
             'defvalue':"",
             'maxlen':2,
             'tooltip':''
             },
            {'name':'testo',
             'title':'Descrizione testuale',
             'type':'str',
             'defvalue':"",
             'maxlen':0,
             'optional':True,
             'multiline':True,
             'tooltip':'Descrizione testuale'
             }
            ]
        
        simpledbmodule.__init__(self,name,"Articoli",be,fields,delete=True,table="articoli",menu="Articoli/Anagrafica",sort="codice")
        
        self.addhandler("report",self.report,"Articoli/stampa listino")

    def add_db(self,d,e):
        values=self.be['dbutil'].cleanup_field_params(e,['cod_fornitore'])
        c=self.db.cursor()
        val=values['cod_fornitore']
        c.execute("SELECT * FROM fornitori WHERE codice='%s'" % val)
        
        if len(c.fetchall())==0:
            raise Exception(val + " non e' un codice fornitore valido")        
        
        return simpledbmodule.add_db(self,d,e)
        
    def mod_db(self,d,e):
        values=self.be['dbutil'].cleanup_field_params(e,['cod_fornitore'])
        c=self.db.cursor()
        val=values['cod_fornitore']
        c.execute("SELECT * FROM fornitori WHERE codice='%s'" % val)
        
        if len(c.fetchall())==0:
            raise Exception(val + " non e' un codice fornitore valido")
    
        return simpledbmodule.mod_db(self,d,e)
        
    def report(self,d,e):

        x=self.be['svg'].renderpdf("fattura.svg",{'tipo':'FATTURA','n':'0054','totale':'500,23'})
        
        d._push()
        d.ui(type="print")
        d._pop()
        
        from binascii import b2a_base64
        d._push()

        d.data("<![CDATA["+b2a_base64(x)+"]]>",format="pdf")
        d._pop()
