// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#ifndef __XSTRING_VECTOR_H__
#define __XSTRING_VECTOR_H__

#include <xstringclass.h>


class xstringvector
{
  size_t vsize;
  size_t vincrement;
  size_t vn;
  xstring** v;

public:
  xstringvector(size_t sz,size_t incr=10);
  xstringvector();
  xstringvector(const xstringvector& v);
  xstringvector& operator=(const xstringvector& v);
  inline xstring& operator[](size_t index);
  inline const xstring& operator[](size_t index) const;
  inline size_t n() const;
  void size(size_t sz);
  void clear();
  void append(const xstring& e);
  ~xstringvector();
};


inline size_t xstringvector::n() const
{
  return  vn;
}

inline xstring& xstringvector::operator [](size_t index)
{
  if (/*index>=0 && */ index<vn)
    return *v[index];
  cout << "Error: Index out of bounds!!! in xstringvector::operator[]" << endl;
  abort();
}


inline const xstring& xstringvector::operator [](size_t index) const
{
  if (/*index>=0 && */ index<vn)
    return *v[index];
  cout << "Error: Index out of bounds!!! in xstringvector::operator[]" << endl;
  abort();
}



#endif // __XSTRING_VECTOR_H__
