// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#include <cstdlib>

#include "xstringvector.h"

xstringvector::xstringvector(size_t sz, size_t incr):vsize(sz>0?sz:1), vincrement(incr>0?incr:1),vn(0),v(NULL)
{
  size(vsize);
}


xstringvector::xstringvector():vsize(1), vincrement(10), vn(0),v(NULL)
{
  size(vsize);
}


xstringvector::xstringvector(const xstringvector& b):vsize(b.vsize), vincrement(b.vincrement), vn(b.vn),v(NULL)
{
  (*this)=b;
}


xstringvector& xstringvector::operator=(const xstringvector& b)
{
  if (&b == this) return *this;

  clear();
  size(b.vsize);
  vincrement=b.vincrement;
  vn=b.vn;

  for(size_t i=0; i<vn; ++i)
    v[i]=new xstring(b[i]);

  return *this;
}


void xstringvector::size(size_t sz)
{
  xstring** p = new xstring*[sz+1];
  if (sz<1) sz=1;
  if(sz<vn) vn=sz;
  for(size_t i =0; i<vn; ++i)
    {
      p[i]=v[i];
    }
  if (v) delete [] v;
  v=p;
  vsize=sz;
}

void xstringvector::clear()
{
  for(size_t i=0; i<vn; ++i)
    {
      if (v&& vsize>0) delete v[i];
    }
  vn=0;
}

void xstringvector::append(const xstring& e)
{
  if (vsize==vn)
    size(vsize+vincrement);
  v[vn++]=new xstring(e);
}


xstringvector::~xstringvector()
{
  clear();
  delete[] v;
  vsize=0;
}
