// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 
 
#ifndef __XSTRING_LIST_H__
#define __XSTRING_LIST_H__

#include <xstringclass.h>

class xstringlistitem;

class xstringlistitem
{
  xstring my_value;

  xstringlistitem* my_next;
  xstringlistitem* my_prev;

 public:
  xstringlistitem(const xstring& value);
  xstringlistitem(const xstringlistitem& copy);
  ~xstringlistitem();

  xstringlistitem* next();
  const xstringlistitem* next() const;
  /* 
     xstringlistitem* prev();
     const xstringlistitem* prev() const;
  */

  xstring value() const;
 
  void set(const xstring& value);
  xstringlistitem& operator=(const xstring& value);

  void setnext(xstringlistitem* i);
};

class xstringlist
{
  xstringlistitem *my_head;

 public:
  xstringlist();
  xstringlist(const xstr * values);
  xstringlist(const xstring * values, size_t n);
  ~xstringlist();

  void fromvector(const xstr* values);
  void fromvector(const xstring* values, size_t n);
  
  xstringlistitem* head();
  const xstringlistitem* head() const;

  xstringlistitem* tail();
  const xstringlistitem* tail() const;

  xstringlistitem* getitem(size_t index);
  const xstringlistitem* getitem(size_t index) const;
  
  xstring getvalue (size_t index) const ;

  size_t getsize() const;

  bool hasitem (xstringlistitem * i) const;
  bool hasitem (size_t index) const;

  void additem(xstringlistitem* o);
  void additem(const xstring& value);
 
  void removeitem (size_t index);
  void removeitem (xstringlistitem * i);

  void clear();
};

#endif // __XSTRING_LIST_H__
