// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#include "xstringlist.h"

xstringlistitem::xstringlistitem( const xstring& value)
  :my_value(value)
{
   my_next=my_prev=NULL;
}

xstringlistitem::xstringlistitem( const xstringlistitem& copy)
{
  my_value=copy.value();
  my_next=my_prev=NULL;
}

xstringlistitem::~xstringlistitem()
{

}

xstringlistitem* xstringlistitem::next()
{
  return my_next;
}

const xstringlistitem* xstringlistitem::next() const
{
  return my_next;
}
/*
xstringlistitem* xstringlistitem::prev()
{
  return my_prev;
}

const xstringlistitem* xstringlistitem::prev() const
{
  return my_prev;
}
*/
xstring xstringlistitem::value () const
{
  return my_value;
}

void xstringlistitem::set(const xstring& value)
{
  my_value=value;
}

void xstringlistitem::setnext(xstringlistitem* i)
{
  my_next=i;
}

xstringlist::xstringlist ()
{
  my_head=NULL;
}

xstringlist::xstringlist( const xstr* values)
{
  my_head=NULL;
  fromvector(values);
}

xstringlist::xstringlist( const xstring* values,size_t n)
{
  my_head=NULL;
  fromvector(values,n);
}

xstringlist::~xstringlist()
{
  clear();
}


void xstringlist::fromvector(const xstr* values)
{
  clear();
  const xstr * p=values;
  while(*p)
    {
      additem(*p);
      p++;
    }
}

void xstringlist::fromvector(const xstring* values,size_t n)
{
  clear();
  const xstring* p=values;
  size_t i=0;
  for(;i<n;++i)
    {
      additem(p[i]);
    }
}

xstringlistitem* xstringlist::head()
{
  return my_head;
}

const xstringlistitem* xstringlist::head() const
{
  return my_head;
}

xstringlistitem* xstringlist::tail()
{
  xstringlistitem *p = head();
  while( p && p->next() )
    {
      p=p->next();
    }
  return p;
}

const xstringlistitem* xstringlist::tail() const
{
  const xstringlistitem *p = head();
  while( p && p->next() )
    {
      p=p->next();
    }
  return p;
}


xstringlistitem* xstringlist::getitem(size_t index) 
{
  xstringlistitem *p=head();
  size_t i=0;
  while(p)
    {
      if(i==index)
	return p;

      ++i;
      p=p->next();
    }
  return NULL;
}

const xstringlistitem* xstringlist::getitem(size_t index) const
{
  const xstringlistitem *p=head();
  size_t i=0;
  while(p)
    {
      if(i==index)
	return p;

      ++i;
      p=p->next();
    }
  return NULL;
}


xstring xstringlist::getvalue(size_t index) const
{
  const xstringlistitem* i = getitem(index);
  
  if(i)
    return i->value();
  
  return "";
}

size_t xstringlist::getsize() const
{
  const xstringlistitem *p=head();
  size_t i=0;
  
  while(p)
    {
      ++i;
      p=p->next();
    }
  
  return i;
}


void xstringlist::additem(xstringlistitem* o)
{
  if(my_head)
    o->setnext(my_head);
  else
    o->setnext(NULL);
  
  my_head=o;
}

bool xstringlist::hasitem (xstringlistitem * i) const
{
  if(!i) return false;
  const xstringlistitem *p=head();
  while(p)
    {
      if(p==i)
	return true;
      p=p->next();
    }
  return false;  
}

bool xstringlist::hasitem (size_t index) const
{
  return index < getsize();
}

void xstringlist::additem( const xstring& value)
{
  additem( new xstringlistitem(value) );
}
 
void xstringlist::removeitem (size_t index)
{
  xstringlistitem * p = getitem(index);
  removeitem(p);
}

void xstringlist::removeitem (xstringlistitem * i)
{
  bool found = hasitem(i);

  if (!found) return;

  // it's the first element??
  if( i == my_head)
    {
      xstringlistitem * t = my_head->next();
      delete my_head;
      my_head=t;
    }
  else 
    {
      // find the previous element
      xstringlistitem * p = my_head;
      while (p)
	{
	  if ( p->next() == i )
	    {
	      //cool
	      break;
	    }
	  p=p->next();
	}
      // p now is the i->prev() element
      // setup all...
      p->setnext(i->next());
      delete i;
    }
  // Done
  
}

void xstringlist::clear()
{
  xstringlistitem *i=head();
  xstringlistitem *p=NULL;
  while(i)
    {
      p=i->next();
      delete i;
      i=p;
    }
  my_head=NULL;
  // Done
}
