// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 
 

#ifndef __XSTRING_HASH_H__
#define __XSTRING_HASH_H__

#include <xstringclass.h>

class xstringhashitem;

class xstringhashitem
{
  xstring my_name;
  xstring my_value;
  void * my_data;

  xstringhashitem* my_next;
  xstringhashitem* my_prev;

  
 public:
  xstringhashitem(const xstring& name, const xstring& value, void* data=NULL);
  ~xstringhashitem();
  xstringhashitem(const xstringhashitem& copy);
  
  xstringhashitem* next();
  const xstringhashitem* next() const;
  /* 
     xstringhashitem* prev();
     const xstringhashitem* prev() const;
  */
  xstring value() const;
  xstring name() const;
  void* data();
  const void* data() const;

  void set(const xstring& name, const xstring& value, void *data=NULL);
  void setnext(xstringhashitem* i);
  
};

class xstringhash
{
  xstringhashitem *my_head;
  int my_case;

 public:
  xstringhash();
  ~xstringhash();

  xstringhash(const xstringhash& copy);

  xstringhash& operator=(const xstringhash& copy);

  xstringhashitem* head();
  const xstringhashitem* head() const;

  xstringhashitem* tail();
  const xstringhashitem* tail() const;

  xstringhashitem* getitem(const xstring& name);
  const xstringhashitem* getitem(const xstring& name) const;

  xstringhashitem* getitem(size_t index);
  const xstringhashitem* getitem(size_t index) const;
  
  xstring getvalue(const xstring& name) const;
  xstring getname (size_t index) const ;
  signed long int getindex (const xstring& name) const;

  size_t getsize() const;


  bool hasitem (xstringhashitem * i) const;
  bool hasitem (const xstring& name) const;
  bool hasitem (size_t index) const;

  void additem(xstringhashitem* o);
  void additem(const xstring& name, const xstring& value, void* data=NULL);
  void additemfromstring(const xstring & str, char sep, void * data=NULL);
  
  void removeitem (const xstring& name);
  void removeitem (xstringhashitem * i);  
  void clear();


  enum {
    Case,
    NoCase
  };
  void setcase(int case_);
};

#endif // __XSTRING_HASH_H__
