// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 
 

#include "xstringhash.h"
#include "xstringvector.h"

xstringhashitem::xstringhashitem(const xstring& name, const xstring& value,void* data)
  :my_name(name),my_value(value)
{
  my_data=data;
}

xstringhashitem::xstringhashitem(const xstringhashitem& copy)
{
  my_name=copy.my_name;
  my_value=copy.my_value;
  my_data=copy.my_data;
}

xstringhashitem::~xstringhashitem()
{
  
}


xstringhashitem* xstringhashitem::next()
{
  return my_next;
}

const xstringhashitem* xstringhashitem::next() const
{
  return my_next;
}
/*
xstringhashitem* xstringhashitem::prev()
{
  return my_prev;
}

const xstringhashitem* xstringhashitem::prev() const
{
  return my_prev;
}
*/
xstring xstringhashitem::value () const
{
  return my_value;
}

xstring xstringhashitem::name () const
{
  return my_name;
}

void* xstringhashitem::data ()
{
  return my_data;
}

const void* xstringhashitem::data () const
{
  return my_data;
}



void xstringhashitem::set(const xstring& name, const xstring& value, void *data)
{
  my_name=name; my_value=value; my_data=data;
}

void xstringhashitem::setnext(xstringhashitem* i)
{
  my_next=i;
}



xstringhash::xstringhash ()
  :my_case(Case)
{
  my_head=NULL;
}


xstringhash::xstringhash(const xstringhash& copy)
  :my_case(Case)
{
  my_head=NULL;
  *this=copy;
}

xstringhash& xstringhash::operator=(const xstringhash& copy)
{
  if(&copy == this) return *this;
  clear();
  
  xstringhashitem *p= copy.my_head;

  while(p)
    {
      additem(new xstringhashitem(*p));
      p=p->next();
    }

  return *this;
}


xstringhash::~xstringhash()
{
  clear();
}

xstringhashitem* xstringhash::head()
{
  return my_head;
}

const xstringhashitem* xstringhash::head() const
{
  return my_head;
}

xstringhashitem* xstringhash::tail()
{
  xstringhashitem *p = head();
  while( p && p->next() )
    {
      p=p->next();
    }
  return p;
}

const xstringhashitem* xstringhash::tail() const
{
  const xstringhashitem *p = head();
  while( p && p->next() )
    {
      p=p->next();
    }
  return p;
}

xstringhashitem* xstringhash::getitem(const xstring& name)
{
  xstringhashitem *p=head();
  while(p)
    {
      if(my_case == Case)
	{
	  if(p->name()==name)
	    return p;
	}
      else
	if(p->name().comparenocase(name)==0)
	   return p;

      p=p->next();
    }
  return NULL;
} 

const xstringhashitem* xstringhash::getitem(const xstring& name) const
{
  const xstringhashitem *p=head();
  while(p)
    {
      if(my_case == Case)
	{
	  if(p->name()==name)
	    return p;
	}
      else
	if(p->name().comparenocase(name)==0)
	   return p;
      p=p->next();
    }
  return NULL;
}


xstringhashitem* xstringhash::getitem(size_t index) 
{
  xstringhashitem *p=head();
  size_t i=0;
  while(p)
    {
      if(i==index)
	return p;

      ++i;
      p=p->next();
    }
  return NULL;
}

const xstringhashitem* xstringhash::getitem(size_t index) const
{
  const xstringhashitem *p=head();
  size_t i=0;
  while(p)
    {
      if(i==index)
	return p;

      ++i;
      p=p->next();
    }
  return NULL;
}


xstring xstringhash::getvalue(const xstring& name) const
{
  const xstringhashitem* i = getitem(name);
  
  if(i) 
    return i->value();
  
  return "";
}

xstring xstringhash::getname(size_t index) const
{
  const xstringhashitem* i = getitem(index);
  
  if(i)
    return i->name();

  return "";
}

signed long int xstringhash::getindex (const xstring& name ) const
{
  const xstringhashitem *p=head();
  size_t i=0;
  while(p)
    {
      if(my_case==Case)
	{
	  if(name==p->name())
	    return i;
	}
      else
	if(name.comparenocase(p->name()) == 0 )
	   return i;

      ++i;
      p=p->next();
    }
  return -1;
}

size_t xstringhash::getsize() const
{
  const xstringhashitem *p=head();
  size_t i=0;
  
  while(p)
    {
      ++i;
      p=p->next();
    }
  
  return i;
}


void xstringhash::additem(xstringhashitem* o)
{
  xstringhashitem * f= getitem(o->name());

  if(f)  // replace
    f->set(o->name(),o->value(),o->data());
  else 
    {
      o->setnext(my_head);


      my_head=o;
    }
}

bool xstringhash::hasitem (xstringhashitem * i) const
{
  if(!i) return false;
  const xstringhashitem *p=head();
  while(p)
    {
      if(p==i)
	return true;
      p=p->next();
    }
  return false;  
}

bool xstringhash::hasitem (const xstring& name) const
{
  const xstringhashitem *p=head();
  while(p)
    {
      if( my_case == Case )
	{
	  if( p->name() == name )
	    return true;
	}
      else
	if(p->name().comparenocase(name) ==0 )
	  return true;
	   
      p=p->next();
    }
  return false;  
}

bool xstringhash::hasitem (size_t index) const
{
  return index < getsize();
}

void xstringhash::additem(const xstring& name, const xstring& value, void* data)
{
  additem( new xstringhashitem(name,value,data) );
}
 
void xstringhash::additemfromstring(const xstring & str, char sep, void * data)
{
  xstringvector a = str.splitc(sep,1) ;
  if(a.n()<=1)
    additem(str,"",data);
  else
    additem (a[0],a[1],data);
}

void xstringhash::removeitem (const xstring& name)
{
  removeitem( getitem(name) );
}

void xstringhash::removeitem (xstringhashitem * i)
{
  bool found = hasitem(i);

  if (!found) return;

  // it's the first element??
  if( i == my_head)
    {
      xstringhashitem * t = my_head->next();
      delete my_head;
      my_head=t;
    }
  else 
    {
      // find the previous element
      xstringhashitem * p = my_head;
      while (p)
	{
	  if ( p->next() == i )
	    {
	      //cool
	      break;
	    }
	  p=p->next();
	}
      // p now is the i->prev() element
      // setup all...
      p->setnext(i->next());
      delete i;
    }
  // Done
  
}


void xstringhash::clear()
{
  xstringhashitem *i=head();
  xstringhashitem *p=NULL;

  while(i)
    {
      p=i->next();
      delete i;
      i=p;
    }
  my_head=NULL;
  // Done
}


void xstringhash::setcase (int case_)
{
  my_case=case_;
}
