// -*- Mode: C++ -*-
//
//    xstring - An useful string class
//
//    Copyright (C) 2004/2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <string>
#include <new>
#include <iostream>

#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#include "xstringclass.h"
#include "xstringvector.h"

#ifndef MAX 
# define MAX(x,y)((x)>(y)?(x):(y))
#endif
#ifndef MIN
# define MIN(x,y)((x)<(y)?(x):(y))
#endif


xstring::xstring()
{
  s=0; sz=10; nullchr=0; binary =false;
  g=0;
  alloc(sz);
  s[0]=0;
}

xstring::xstring(const xstr str, bool dup)
{
  s=0; sz=0; nullchr=0; binary =false;
  g=0;
  //*this=str;

  xpos l=xstrlen(str);
  
  if(dup)
    {
      alloc(l+1);
      
      xstrncpy(s,str,l);
      s[l]=0;
    }
  else
    {
      s=(xstr)str;
      sz=l+1;
    }

  freebuff=dup;
}

xstring::xstring(const xstring& str)
{
  s=0; sz=0; nullchr=0; binary=str.binary; binarylen=str.binarylen;
  g=0; freebuff=true;
  //*this=str;

  xpos l=str.length();

  alloc(l+1);

  xstrncpy(s,str.text(),l);
  s[l]=0;  
}

xstring::xstring(xpos size)
{
  s=0; sz=0; nullchr=0; binary =false;
  g=0;
  alloc(size+1);
  s[0]=0;
}


xstring::xstring(xchr chr,xpos n)
{
  s=0; sz=0; nullchr=0; binary =false;
  g=0;
  fill(chr,n);
}
/*
xstring::xstring(const xstring& str,xpos n):s(NULL),sz(0),nullchr(0)
{
  //fill(str,n);
  
}*/

// binary string
xstring::xstring(const xstr str,xpos n)
{
  s=0; sz=0; nullchr=0; binary =true;
  g=0;
  //fill(str,n);
  frombinary(str,n);
}

xstring::~xstring()
{
  free();
  s=0;
  sz=0;
}

void xstring::alloc(xpos size)
{
  free();
  freebuff=true;
  s=xstrnew(size+1 ); //new xchr[size+1];
  if (!s) { perror("xstring::alloc: memory allocation error: ");abort();}
  //fprintf(stdout,"allocated string: %x\n",s);
  s[0]=0;
  sz=size;
}

void xstring::resize(xpos size)
{
  char *buff;
  xpos l=length();
  if(size<0) size=0;
  
  
  buff= xstrnew(size+5); //new xchr[size+1];
  //fprintf(stdout,"allocated string: %x\n",buff);
  
  xpos f=MIN(l,size);
  xstrncpy(buff,s,f);
  buff[f]=0;  
  free();

  freebuff=true;

  sz=size;
  s=buff;
}

void xstring::free()
{ 
    //fprintf(stdout,"freeing string: %x\n", s);
  if(freebuff)
    xstrfree(s);
    //fprintf(stdout,"freed string: %x\n", s);
  s=0; //NULL;
  sz=0;
}

void xstring::growth(xpos n)
{
   g=n;
}

xpos xstring::allocatedsize() const
{
  return sz;
}

void xstring::adjust()
{
  if (binary) return;
  if(!overflows()) resize(length()+1);
}

xpos xstring::length() const
{
  if(binary) return binarylen;
  if(!s || sz<1|| !s[0]) return 0;
  return xstrlen(s,sz);
}

// set binary length. Binary mode only!!!
void xstring::setlength(xpos l)
{
  if (!binary) return;
  if (sz<l) alloc(l+1);
  binarylen=l;
}

xpos xstring::len() const 
{
  return length();
}

xpos xstring::size() const 
{
  return length();
}
 
void xstring::truncate(xpos len)
{
  // TODO: improve!! free memory?
  if (sz<=0 || !s || length()<=len) return;
  if (binary)
    binarylen=len;
  else 
    setat(len,0);
}

bool xstring::isbinary() const
{
  return binary;
}

void xstring::setbinary(bool cond)
{
  binary=cond;
}

// inlined
#if 0
const xchr& xstring::operator[](xpos index) const
{
  if (sz>0 && s && index>=0 && index <sz/*&& index<length()*/)
    return s[index];
  std::cerr<< "Error! xstring::operator[] index out of bounds!! s: " << s << " sz: " << sz <<  std::endl;
  abort(); // FIXME: is this necessary???
}

xchr& xstring::operator[](xpos index)
{
  if (sz>0 && s && index>=0 && index <sz/*&& index<length()*/)
    return s[index];

  std::cerr<< "Error! xstring::operator[] index out of bounds!! s: " << s << " sz: " << sz <<  std::endl;
  abort();// FIXME: is this necessary???
}
#endif

xchr& xstring::at(xpos index)
{
  if (sz>0 && s && index>=0 && index <sz/*&& index<length()*/)
    return s[index];
  std::cerr<< "Error! xstring::at(index) index out of bounds!!" << std::endl;
  abort();// FIXME: is this necessary???
}
//TODO: resize the string to keep the value!
const xchr& xstring::at(xpos index) const
{
  if (sz>0 && s && index>=0 && index<sz)
    return s[index];
  std::cerr<< "Error! xstring::at(index) index out of bounds!!" << std::endl;
  abort();// FIXME: is this necessary???
}

xchr xstring::getat(xpos index) const
{
  if (sz>0 && s && index>=0 && index<sz)
    return s[index];
  else 
    std::cerr<< "Warning! xstring::getat(index) index out of bounds!!" << std::endl;
  return 0; // abort? complain?
}

//TODO: resize the string to keep the value!??

void xstring::setat(xpos index, xchr c)
{
  if (sz>0 && s && index>=0 && index<sz)
    s[index]=c;
  else
    std::cerr<< "Warning! xstring::setat(index) index out of bounds!!" << std::endl;
  // complain?
}


void xstring::fillrange(xpos a,xpos b, xchr c)
{
  xpos l=length();
  
  if(a>b) { xpos tmp=a; a=b; b=tmp; }
  if (a<0) a=0; 
  if (b>=sz) b=sz-1;
  
  xpos i;
  for (i=a; i<=b; ++i)
    s[i]=c;
  if (i==sz||i>l) s[i]=0;
}

void xstring::fill(xchr c, xpos n)
{
  if(sz<n||!s) alloc(n+1);
  if (n<0)n=-n;
  xpos i;
  for(i=0; i<n; ++i)
    {
      setat(i,c);
    }
  setat(i,0);
}

xstr xstring::duplicate()const
{
  // TODO: Check if empty!!
  xpos l=length();
  xstr d=xstrnew (l+1);

  xstrncpy(d,s,l);
  //d[l]=0;
  return d;
}

std::string xstring::string () const
{
  // TODO: checkk this!!!!!
  if(xstrlen(s)<sz) 
    return std::string(s);
  else
    {
      xstring tmp=mid(0,sz-1);
      return std::string(tmp.c_str());
    }
}

// use with caution!!!
xstr xstring::getbuffer()
{ 
  return s;
}

const xstr xstring::gets() const
{  
  if(sz>0)  return s;
  return NULL;
}

const xstr xstring::text() const
{
  return gets();
}

const xstr xstring::c_str() const
{
  return gets();
}

void xstring::delat(xpos index)
{
  // check domain
  if (index <0 || index>=sz) return;
  
  xpos i=index;
  xpos l=length();
  for (;i<l; ++i)
    s[i]=s[i+1];
}

void xstring::delrange(xpos a, xpos b)
{
  if (a > b) { xpos tmp=a; a=b; b=tmp; }
  // check domain
  if (a<0) a=0;
  xpos l=length();
  if(b>=l) b=l-1;
  
  xpos d=b-a+1;
  if (!d) return;

  xpos i;
  for (i=a; i<l-d; ++i)
    s[i]=s[i+d];
  s[i]=0;
}

void xstring::clear()
{
  if(sz>0&& s) s[0]=0;
  binarylen=0;
}

void xstring::fill(const xstr str, xpos ns)
{
  xpos l=xstrlen(str); 
  alloc(l*ns+1);

  for(xpos i=0; i<ns; ++i)
    {
      *this+=str;
    }
}

// TODO: optimize this!!

void xstring::fill(const xstring& str, xpos ns)
{
  xpos l=str.length();
  alloc(l*ns+1);

  for(xpos i=0; i<ns; ++i)
    {
      *this+=str;
    }
}

// ufff!!! : FIXED!!
xstringvector xstring::splitc(xchr sep, int maxseps) const
{
  xpos l=length();
  xpos n=occurrences(sep)+1;
  xstringvector x( (maxseps>0?maxseps:n) +2 ); //=new xstring*[(maxseps>0?maxseps:n)+2];

  xpos i,j=-1,y=0;
  for(i=0; i<l && (maxseps>0?y<maxseps:true); ++i)
    if (s[i]==sep)
	{
	  x.append( mid(j+1,i-j-1) );
	  j=i;
	  ++y;
	}
  x.append ( mid(j+1,l-j-1) );
  //x[y+1]=0;//NULL
  return x;
}

xstringvector xstring::splitc(const xstring& sep) const
{
  xpos l=length();
  xpos n=occurrences(sep)+1;
  xstringvector x(n+2);
  
  xpos i,j=-1,y=0;
  for(i=0; i<l; ++i)
    if (sep.occurrences(s[i])>0)
	{
	  x.append( mid(j+1,i-j-1) );
	  j=i; 
	}
  x.append ( mid(j+1,l-j-1) );
  // x[y+1]=0;//NULL
  return x;
}

xstringvector xstring::splits(const xstring& sep) const
{
  xpos l=length(); xpos ls=sep.length();
  xpos n=occurrences(sep)+1;

  xstringvector x (n+2);

  if(n==1) 
    {
      x.append(s);
      // x[1]=0; // NULL
      return x;
    }
  
  xpos i,j=0,y=0;
  for(i=0; i<l; ++i)
    if (mid(i,ls)==sep)
	{
	  x.append( mid(j,i-j) );
	  i+=ls-1; 
	  j=i+1;
	  ++y;
	}
  if(y==(n-1))
     x.append ( mid(j,i-j) );
  //x[y+1]=0;//NULL
  return x;
}



xstringvector xstring::splitss(const xstringvector& seplist, int maxseps) const
{
  xpos l=length(); xpos* ls=NULL;
  /*
  long nsep=0;
  if (seplist)
    for (; seplist[nsep]; ++nsep);
  */
  int nsep=seplist.n();

  ls=new xpos[nsep+2];
  for(int ii=0; ii<nsep; ++ii) ls[ii]=seplist[ii].length();

  xpos n=0;
  for(int h=0; h<nsep; ++h)
    if(ls[h]) n+=occurrences(seplist[h]);
    
  n++;

  xstringvector x( (maxseps>0?maxseps:n)+2 );

  if(n==1) 
    {
      x.append(s);
      //x[1]=0; // NULL
      return x;
    }
  
  xpos i,j=0,y=0;
  for(i=0; i<l && (maxseps>0?y<maxseps:true); ++i)
    for(xpos jx=0; jx<nsep; ++jx)
      if (ls[jx] && mid(i,ls[jx])==seplist[jx])
	{
	  x.append( mid(j,i-j) );
	  i+=ls[jx]-1; j=i+1;
	  ++y;
	  break;
	}
  if (y == n-1)
    {
      x.append( mid(j,i-j) );
      //  x[y+1]=0;
    }
  else if(y<n)
    {
      x.append( mid(j,l-j) );
      //      x[y+1]=NULL;
    }
  /*
    else
    x[y+1]=0;//NULL
  */
  return x;
}
  
xstring xstring::mid (xpos start, xpos len) const
{
  xpos l=length();

  if (len<1) return "";
  if (start<0) start=0;
  if (start+len>l) len=l-start;
  
  xstring str(s+start,len);

  /* // uggghhh!!
  for ( ; i<start+len; ++i)
    str[i-start]=this->s[i];
  str[i-start]=0;
  */
  return str;
}

xstring xstring::left (xpos len) const
{
  xpos l=length();
   if (len>0 && len<=l)
    {
      xstring t(len+5);
      //xpos i;
      //for ( i=0; i<len; ++i)
      //t[i]=this->s[i];
      //t[i]=0;
      xstrncpy(t.s,s,len);
      return t;
    }
   return "";
}

xstring xstring::right (xpos len) const
{
  xpos l=length();
  if (len>0 && len<=l)
    {
      xstring t(len+5);
      //xpos i,j;
      //for ( j=0,i=l-len; i<l; ++i,++j)
      //t[j]=s[i];
      //t[j]=0;
      xstrncpy(t.s,s+l-len,len);
      return t;
    }
   return xstring();
}

void  xstring::setrange(xpos a,xpos b,const xstr t)
{
  if( a>b ) { a^=b; b^=a; a^=b; }
  xpos d=b-a;
  if (!d) return;
  xpos m=xstrlen(t);
  if (!m ) return;

  xpos l=length();
  
  xpos i;
  if(m==d)
    {
      for (i=0; i<m; ++i)
	s[a+i]=t[i];
    }
  else if(m<d)
    {
      delrange(a,a+d-m);
      setrange(a,a+m,t);
    }
  else // m>d right?
    { // TODO check this!
      // let's shift!
      xpos q=m-d;
      if (allocatedsize()<q+l||l<b) alloc(l+q+1);
      for (i=b-q; i<l; ++i)
	s[i+q]=s[i];
      s[i+q]=0;
      setrange (a,a+m,t);
    }
}

void  xstring::setrange(xpos a,xpos b,const xstring& t)
{
  if( a>b ) { a^=b; b^=a; a^=b; }
  xpos d=b-a;
  if (!d) return;
  xpos m=t.length();
  if (!m ) return;

  xpos l=length();
  
  xpos i;
  if(m==d)
    {
      for (i=0; i<m; ++i)
	s[a+i]=t[i];
    }
  else if(m<d)
    {
      delrange(a,a+d-m);
      setrange(a,a+m,t);
    }
  else // m>d right?
    { // TODO check this!
      // let's shift!
      xpos q=m-d;
      if (allocatedsize()<q+l||l<b) alloc(l+q+1);
      for (i=b-q; i<l; ++i)
	s[i+q]=s[i];
      s[i+q]=0;
      setrange (a,a+m,t);
    } 
}

xstring & xstring::operator= (const xstring& str)
{
  xpos l=str.length();

  if(l>=sz) alloc(l+1);

  xstrncpy(s,str.text(),l);
  s[l]=0;  
  if(binary=str.binary) binarylen=str.binarylen;

  return *this;
}

xstring & xstring::operator= (const xstr str)
{
  xpos l=xstrlen(str);

  alloc(l+1);
  
  xstrncpy(s,str,l);
  s[l]=0;    
  binary=0;
  return *this;
}

xstring & xstring::operator= (const std::string & str)
{
  xpos l=str.length();

  alloc(l+1);
  xstrncpy(s,str.c_str(),l);
  s[l]=0;    
  binary=0;
  return *this;
}

  // comparisons
int xstring::compare ( const xstring& str ) const
{
  xpos l=str.length();
  xpos sl=length();
  if (l==0 && sl==0) return 0;

  xpos m=min(l,sl);

  for (xpos i=0; i<m; ++i)
    {
      if(str[i]<s[i]) return +1;
      if(str[i]>s[i]) return -1;
    }

  if (l==0) return +1;
  if (sl==0) return -1;

  if (l<sl) return +1;  
  if (l>sl) return -1;

  return 0;
}

int xstring::compare ( const xstr str ) const
{
  xstring a(str,false);
  
  return compare(a);
}

int xstring::comparenocase ( const xstring& str ) const
{
  xpos l=str.length();
  xpos sl=length();
  if (l==0 && sl==0) return 0;
  
  for (xpos i=0; i<l; ++i)
    {
      xchr x=::tolower(str[i]),y=::tolower(s[i]);
      
      if(x<y) return +1;
      if(x>y) return -1;
    }

  if (l==0) return +1;
  if (sl==0) return -1;

  if (l<sl) return +1;  
  if (l>sl) return -1;

  return 0;
}

int xstring::comparenocase ( const xstr str ) const
{
  xstring a(str,false);
  
  return comparenocase(a);
}


bool xstring::operator== (const xstring& str) const
{
  return (compare(str)==0);
}

bool xstring::operator>= (const xstring& str) const
{
  return (compare(str)>=0);
}

bool xstring::operator<= (const xstring& str) const
{
  return (compare(str)<=0);
}

bool xstring::operator<  (const xstring& str) const
{
  return (compare(str)<0);
}

bool xstring::operator>  (const xstring& str) const
{
  return (compare(str)>0);
}

bool xstring::operator!= (const xstring& str) const
{
  return (compare(str)!=0);
}


xstring  xstring::operator+ (const xstring& t) const
{
  xstring str(*this);
  str+=t;
  return str;
}

xstring xstring::operator+ ( const xstr t) const
{
  xstring str(*this);
  str+=t;
  return str;
}

xstring  xstring::operator+ (const int t) const
{
  return *this+fromint(t);
}

xstring  xstring::operator+ (const long t) const
{
  return *this+ fromlong(t);
}

xstring  xstring::operator+ (const float t) const
{
  return *this+ fromfloat(t);
}

xstring  xstring::operator+ (const double t) const
{
  return *this+ fromdouble(t);
}

/*
xstring xstring::operator- (const xstring& sa, const xstring& sb) const
{

}
*/

xstring& xstring::operator+= (const xstring& str)
{
  xpos l=length();
  xpos ls=str.length();

  if(sz<=l+ls)
    {
      xpos dim=l+MAX(ls,g)+1;
#ifdef DEBUG
      std::cout << "xstring::operator+= allocating " << dim << " bytes.\n";
#endif
      xstr buff= xstrnew(dim); //new xchr[l+MAX(ls,g)+1];
      //fprintf(stdout,"allocated string: %x\n",buff);

      xstrncpy(buff,s,l);
      free(); // ahieee
      sz=dim;
      freebuff=true;
      s=buff;
    }
  xstrncpy(s+l,str.text(),ls);
  s[ls+l]=0;

  if(str.isbinary()||binary) 
    {
      setbinary();
      binarylen=l+ls;
    }
  return *this;
}  

xstring& xstring::operator+= (const xstr str)
{
  xstring a (str,false);
  return operator+= (a);
}

/*
xstring& xstring::operator-= (const xstring& str)
{

}
*/

bool xstring::operator== (const xstr str) const
{
  return (compare(str)==0);
}

bool xstring::operator>= (const xstr str) const
{
  return (compare(str)>=0);
}

bool xstring::operator<= (const xstr str) const
{
  return (compare(str)<=0);
}

bool xstring::operator<  (const xstr str) const
{
  return (compare(str)<0);
}

bool xstring::operator>  (const xstr str) const
{
  return (compare(str)>0);
}

bool xstring::operator!= (const xstr str) const
{
  return (compare(str)!=0);
}

xstring&  xstring::operator<< (const xstring& str)
{
  return *this += str;
}

xstring&  xstring::operator<< (const xstr str)
{
  return *this += str;
}

xstring&  xstring::operator<< (xchr c)
{
  return *this += c;
}

xstring&  xstring::operator<< (long n)
{
  return *this += fromlong(n);
}

xstring&  xstring::operator<< (float f)
{
  return *this += fromfloat(f);
}

xstring&  xstring::operator<< (double d)
{
  return *this += fromdouble(d);
}

bool xstring::operator! () const
{
  return (length()<=0);
}

bool xstring::isempty() const
{
  return (length()<=0);
}

bool xstring::notempty() const
{
  return (length()>0);
}

bool xstring::overflows() const
{
  return (s && sz<xstrlen(s));
}

void xstring::toupper()
{
  xpos l=length();
  for (xpos i=0; i<l; ++i)
    {
      s[i]=::toupper(s[i]);
    }
}

void xstring::tolower()
{
  xpos l=length();
  for (xpos i=0; i<l; ++i)
    {
      s[i]=::tolower(s[i]);
    }
}

void xstring::trim()
{
  triml(); trimr();
}

void xstring::trimr()
{
  xpos l=length();
  int x=0;

  xpos i=l-1;
  // xpos j=l-1;
  
  for (; i>=0; --i)
    {
      switch (s[i])
	{
	case 0x20: case '\t': case '\n': case '\r':
	  if(x!=1) break;
	default:
	  s[i+1]=0;
	  return;
	}
    }
  //  s[l-j]=0;
}

void xstring::triml()
{
  xpos l=length();
  int x=0; xpos j=0,i=0;
  for (; i<l; ++i)
    {
      switch (s[i])
	{
	case 0x20: case '\t': case '\n': case '\r':
	  if(x!=1) break;
	default:
	  x=1; s[j++]=s[i];
	}
    }
  s[j]=0;
}

void xstring::escape_cstyle()
{
  //TODO!!
}

void xstring::escape_sql()
{
  replace ('\'',"''");
  replace ('\\',"\\\\");
}

// conversions copy
xstring  xstring::gettoupper() const
{
  xstring x(*this); x.toupper(); return x;
}

xstring  xstring::gettolower() const
{
  xstring x(*this); x.tolower(); return x;
}

xstring  xstring::gettrim() const
{
  xstring x(*this); x.toupper(); return x;
}

xstring  xstring::gettrimr() const
{
  xstring x(*this); x.trimr(); return x;
}

xstring xstring:: gettriml() const
{
  xstring x(*this); x.triml(); return x;
}
  
xstring xstring::getescape_cstyle() const
{
  return  xstring (*this).getescape_cstyle();
}

int xstring::getint() const
{  
  if (sz<1||!s) return 0;
  if(!overflows())
    return atoi(s);
  xstring s=mid(0,sz-1);
  return atoi(s.c_str());
}

long xstring::getlong() const
{
  if (sz<1||!s) return 0;
  if(!overflows())
    return atol(s);
  xstring s=mid(0,sz-1);
  return atol(s.c_str());
}

float xstring::getfloat() const
{
  if (sz<1||!s) return 0;
  if(!overflows())
    return (float)atof(s);
  xstring s=mid(0,sz-1);
  return (float)atof(s.c_str());
}

double xstring::getdouble() const
{
 if (sz<1||!s) return 0;
  if(!overflows())
    return atof(s);
  xstring s=mid(0,sz-1);
  return atof(s.c_str());
}


xstring xstring::fromint (int n)
{
  xstring s;
  s.format("%d",n);
  return s;
}

xstring xstring::fromlong (long l)
{
  xstring s;
  s.format("%li",l);
  return s;
}

xstring xstring::fromfloat (float f)
{
  xstring s;
  s.format("%f",f);
  return s;
}

xstring xstring::fromdouble (double d)
{
  xstring s;
  s.format("%f",d);
  return s;
}

xstring xstring::fromxstr (const xstr s)
{
  return xstring(s);
}

xstring xstring::fromxchr (xchr c)
{
  xchr s[2];
  s[0]=c;
  s[1]=0;
  return xstring(s);
}


void xstring::frombinary(const xstr str, xpos l)
{
  if(!s||sz<l) alloc(l+1);
  xstrncpy(s,str,l);
  s[l]=0;
  binarylen=l;
  binary=true;
}


// searching

xpos xstring::search (const xstring& s, int occurrence, bool overlap) const
{
  xpos l=length();
  xpos ls=s.length();
  xpos i;

  if (! (ls>0 && l>0) ) return -1;

  for (i=0; i< l-ls; ++i)
    {
      if (s==mid(i,ls))
	{
	  --occurrence;
	  if (occurrence<0) return i;
	  if (!overlap) i+= ls-1;
	}
    }
  return -1;
}

xpos* xstring::searchall (const xstring& s, bool overlap) const
{
  xpos l=length();
  xpos ls=s.length();
  xpos i,o;

  if (! (ls>0 && l>0) ) return NULL;

  xpos n=occurrences(s);
  if ( n< 1) return NULL;

  xpos *v=new xpos[n+1];

  for (i=0,o=0; i< l-ls; ++i)
    {
      if (s==mid(i,ls)) 
	{
	  v[o++]=i;
	  if(!overlap) i+= ls-1;
	}
    }
  v[o]=-1;
  return v;
}

xpos xstring::search (const xstr s, int occurrence, bool overlap) const
{
  xstring a(s,false);
  return search (a,occurrence,overlap);
}

xpos* xstring::searchall (const xstr s,bool overlap) const
{
  xstring a (s,false);
  return searchall(a,overlap);
}

xpos xstring::search (xchr c, int occurrence) const
{
  xpos l=length();
  for (xpos i=0; i<l; ++i)
    {
      if(s[i]==c) occurrence--;
	
      if(occurrence<0) return i;
    }
  return -1;
}

// last vector element = -1
// please free that all!! : xstring::freevect();

xpos* xstring::searchall (xchr c) const
{
  xpos n=occurrences(c);
  if(n<1) return NULL;
  xpos *v=new xpos[n+1];
  xpos l=length();
  xpos i,o;
  for (i=0,o=0; i<l; ++i)
    {
      if(s[i]==c) v[o++]=i;
    }
  v[o]=-1;
  return v;
}

xpos xstring::occurrences(const xstring& s,bool overlap /*=true*/) const
{
  xpos l=length();
  xpos ls= s.length();
  xpos i,o=0;
  for(i=0;i<=l-ls; ++i)
    {
      if(mid(i,ls).compare(s)==0) 
	{
	  ++o;
	  if(! overlap ) i+= ls-1;
	}
    }
  return o;
}

xpos xstring::occurrences(const xstr s, bool overlap) const
{
  xstring a (s,false);
  return occurrences (a,overlap);
}

xpos xstring::occurrences( xchr c) const
{
  xpos l=length();
  xpos n=0;
  for (xpos i=0; i<l; ++i)
    {
      if(s[i]==c) ++n;
    }
  return n;
}

 // replace
int xstring::replace(const xstring& u,const xstring& r, int _n)
{
  xpos *x =searchall(s,false);

  if(!x||x[0]<0) return 0;
  
  xpos n,i,l=length(),lu=u.length(),lr=r.length();

  for(n=0; x[n]>=0;++n);

  n=_n?MAX(n,_n):l;

  xpos nl=l+lr*n+5;
  char* t=xstrnew(nl);

  xpos p=0;
  for(i=0; i<l; ++i)
    {
      if( xstrncmp(s+i,u.text(),lu) == 0 ) 
	{
	  xstrncpy(t+p,r.text(),lr);
	  p+=lr;
	}
      else
	t[p++]=s[i];
    }
  t[p]=0;

  free();
  delete []x;
  freebuff=true;
  s=t;
  sz=nl;
  if(binary||r.isbinary())
    {
      setbinary(true);
      setlength(p);
    }
  return i;
}

int xstring::replace(xchr c, xchr r, int n)
{
  xpos* x=searchall(c);
  if(!x||x[0]<0) return 0;

  xpos i;
  // xpos l=length();


  if(n<=0)
    {
      for (i=0; x[i]>-1; ++i)
	s[x[i]]=r;
    }
  else
    {
      for (i=0; x[i]>-1 && i<n; ++i)
	s[x[i]]=r;
    }
  delete[] x;

  return i;
}


// TODO: create CHECK in test suite
int xstring::replace(const xstring& u,xchr r, int _n)
{
  //  if(!x||x[0]<0) return 0;
  
  xpos n,i,j,l=length(), lu=u.length();

  n=_n>0?_n:l;

  for(i=0,j=0; i<l; ++i)
    {
      if( mid(i,lu) == u && n<_n)
	{
	  i+=lu-1; // do not overlap!
	  n++;
	  s[j++]=r;
	}
      else
	s[j++]=s[i];
    }
  s[j]=0;

  if(binary)
    setlength(j);

  return j;
}

int xstring::replace(xchr c, const xstring& r, int _n)
{
  xpos *x =searchall(c);

  if(!x||x[0]<0) return 0;
  
  xpos n,i,l=length(),ls=r.length();
  for(n=0; x[n]>=0;++n);

  n=_n?MAX(n,_n):n;

  xpos nl=l+ls*n+5;
  char* t=xstrnew(nl);
  xpos p=0;
  for(i=0; i<l; ++i)
    {
      if(s[i]==c)
	{
	  xstrncpy(t+p,r.text(),ls);
	  p+=ls;
	}
      else
	t[p++]=s[i];
    }
  t[p]=0;
  free();
  delete []x;
  freebuff=true;
  s=t;
  sz=nl;
  if(binary||r.isbinary())
    {
      setbinary(true);
      setlength(p);
    }
  return i;
}
  
// TODO: create CHECK in test suite
int xstring::replace(const xstr u,const xstr r, int _n)
{
  xstring a(u,false);
  xstring b(r,false);
  return replace (a,b,_n);
}

// TODO: create CHECK in test suite
int xstring::replace(const xstr u,xchr r, int _n)
{
  xstring a(u,false);
  return replace (a,r,_n);
}

int xstring::replace(xchr c, const xstr r, int _n)
{
  xstring a(r,false);
  return replace(c,a,_n);
}

xpos xstring::delchr(xchr c)
{
  xpos i=0,j;
  xpos l=length();

  for (j=0; i<l; ++i)
    if (s[i]!=c)
	s[j++]=s[i];
      
  s[j]=0;
  return i-j;  
}

  // format!!
xpos xstring::printf(const xstr f, ...)
{
  if(sz<100||!s) alloc(100);
  va_list v;
  xpos n;

  while (true)
    {
      va_start(v,f);
      n=vsnprintf(s,sz,f,v);
      va_end(v);
      if(n<0)
	break;
	
      if (n>-1 && n < sz)
	return n;
      if (n>-1)
	alloc(n+1);
      else
	alloc(sz*2);
    }
  return -1;
}

xpos xstring::format(const xstr f, ...)
{
  if(sz<100||!s) alloc(100);
  va_list v;
  xpos n;

  while (true)
    {
      va_start(v,f);
      n=vsnprintf(s,sz,f,v);
      va_end(v);
      if(n<0)
	break;
	      
      if (n>-1 && n < sz)
	return n;
      if (n>-1)
	alloc(n+1);
      else
	alloc(sz*2);
    }
  return -1;
}

xpos  xstring::appendformat(const xstr f, ...)
{
  xstring s(100);

  va_list v;
  xpos n;

  while (true)
    {
      va_start(v,f);
      n=vsnprintf(s.s,s.allocatedsize(),f,v);
      va_end(v);
      if(n<0)
	break;
	
      if (n>-1 && n < s.allocatedsize())
	break;
      if (n>-1)
	s.alloc(n+1);
      else
	s.alloc(s.allocatedsize()*2);
      
    }
  *this+=s;
  return length();
}

xstring xstring::sprintf(const xstr f, ...)
{
  xstring s(100);

  va_list v;
  xpos n;

  while (true)
    {
      va_start(v,f);
      n=vsnprintf(s.s,s.allocatedsize(),f,v);
      va_end(v);
      
      if (n>-1 && n < s.allocatedsize())
	break;
      if (n>-1)
	s.alloc(n+1);
      else
	s.alloc(s.allocatedsize()*2);
    }
  return s;
}

xpos xstring::xstrlen(const xstr t, xpos allocated)
{
  xpos i; 
  if (!t) return 0;
  if (allocated==0) return 0;

  if(allocated<0)
    { 
      for (i=0;t[i]; ++i); 
      return i;
    }
  
  for (i=0;t[i] && i<allocated; ++i);
  return i;
}

xpos xstring::xstrcpy(xstr d, const xstr s)
{
  xpos i;
  for (i=0; s[i]; ++i)
    d[i]=s[i];
  d[i]=0;
  return i;
}

xpos xstring::xstrncpy(xstr d,const xstr s, xpos n)
{
  xpos i;
  memcpy(d,s,n*sizeof(xchr));
  d[n]=0;
  return i;
}

xpos xstring::xstrcat(xstr d,const xstr s)
{
  xpos i,l = xstrlen(d);
  for (i=0; s[i]; ++i)
    d[i+l]=s[i];
  d[i+l]=0;
  return i+l;
}

xpos xstring::xstrncat(xstr d,const xstr s, xpos n)
{
  xpos i, l= xstrlen(d);
  for (i=0; i<n; ++i)
    d[i+l]=s[i];
  d[i+l]=0;
  return i+l;
}

xstr xstring::xstrnew(xpos l)
{
  //  xstr t=(char*)malloc((l+1)*sizeof(xchr) );
  xstr t=new xchr[l+1];
  //fprintf(stdout,"allocated string: %x\n",t);

  if(!t) perror("xstring::xstrnew():");
  return t;
}

int xstring::xstrncmp(const xstr a, const xstr b, xpos n)
{
  return strncmp(a,b,n);
}

int xstring::xstrcmp(const xstr a, const xstr b)
{
  return strcmp(a,b);
}

void xstring::xstrfree(xstr t)
{
  if(t) delete [] t;
}

void xstring::freevect( xstring* v)
{
  if (v) delete [] v;
}

void xstring::freevect( xstring** v)
{
  xpos i=0;
  if (!v) return;
  for ( ;v[i]; ++i )
    delete v[i];
  delete [] v; 
}
/*
xstring& operator+ (xstring& a, const char* b)
{
  // is this useful?
  a+=b;
  return a;
}*/

xstring operator+ (const char *s, const xstring& t)
{
  xstring a (s);
  a+=t;
  return a;
}

std::ostream& operator << (std::ostream& o, const xstring& s)
{
  o<<s.string();
  return o;
}

void __findxstring(){}
