// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  long i;
  const xstr t="test1\t\ntest2\t\ntest3";
  xstring s(t);

  xstringvector v = s.splits("\t\n");

  if(v.n() != 3 ) fail_test("xstringvector xstring::splits(str):d ");
  if(strcmp(v[0].text(),"test1")) fail_test("xstringvector xstring::splits(str):a ");
  if(strcmp(v[1].text(),"test2")) fail_test("xstringvector xstring::splits(str):b ");
  if(strcmp(v[2].text(),"test3")) fail_test("xstringvector xstring::splits(str):c ");
  
  // stage 2

  v=s.splits("\t\r");

  if (v.n()!=1) fail_test("xstringvector xstring::splits(str):f ");
  if(strcmp(v[0].text(),"test1\t\ntest2\t\ntest3")) fail_test("xstringvector xstring::splits(str):e ");
     
  s="nothing interesting\t\n";
  v=s.splits("\t\n");

  if (v.n() != 2) fail_test("xstringvector xstring::splits(str):i ");

  if(strcmp(v[0].text(),"nothing interesting")) fail_test("xstringvector xstring::splits(str):g ");
  if(strcmp(v[1].text(),"")) fail_test("xstringvector xstring::splits(str):h ");
  
  s="";
  v=s.splits("\t\n");
  if (v.n() !=1) fail_test("xstringvector xstring::splits(str):k ");
  if(strcmp(v[0].text(),"")) fail_test("xstringvector xstring::splits(str):j ");
  
  s="\t\n";
  v=s.splits("\t\n");
  
  if(v.n() != 2) fail_test("xstringvector xstring::splits(str):n ");
  if(strcmp(v[0].text(),"")) fail_test("xstringvector xstring::splits(str):l ");
  if(strcmp(v[1].text(),"")) fail_test("xstringvector xstring::splits(str):m ");
  
  return 0;
}
