// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  
  const xstr t="What's your Name?\n";
  
  xstring s(t);
  s.replace('W','w');
  s.replace('a','A');
  s.replace ('\n','\t');

  if(strcmp(s.text(),"whAt's your NAme?\t")) fail_test("xstring::replace(char,char):a ");

  s=t;
  xstring h="xx";
  s.replace(' ',h);
  if(strcmp(s.text(),"What'sxxyourxxName?\n")) fail_test("xstring::replace(char,const xstring&):b ");
  return 0;
}
