// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  xstringhash h;
  h.additem("marco","polo");
  h.additem("denni","cula");

  if(h.getsize()!=2) fail_test("getsize()");
  
  if(h.getvalue("marco") != "polo" ) fail_test("getvalue() a");
  if(h.getvalue("denni") != "cula" ) fail_test("getvalue() b");

  if(h.getvalue("idiota") != "") fail_test ("getvalue() c");

  h.additem("marco","palo");

  if(h.getvalue("marco") != "palo" ) fail_test("additem() & getvalue() d");
  if(h.getvalue("denni") != "cula" ) fail_test("additem() & getvalue() e");

  h.additem("denni","denni");

  if(h.getvalue("marco") != "palo" ) fail_test("additem() & getvalue() f");
  if(h.getvalue("denni") != "denni" ) fail_test("additem() & getvalue() g");

  h.removeitem("denni");
  if(h.getsize() != 1) fail_test ("removeitem () h");

  if(h.hasitem("denni")) fail_test ("has_item() & removeitem() i");
  if( ! h.hasitem("marco")) fail_test ("has_item() & removeitem() j");

  if(h.hasitem("idiota")) fail_test ("has_item() k");

  return 0;
}
