
// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  xstring s;
  if(s.text()[0]) fail_test("xstring::xstring(void):");
  
  xstring t("test");
  if(strcmp(t.text(),"test")) fail_test("xstring::xstring(const xstr str):");

  xstring u(t);
  if(strcmp(u.text(),t.text())) fail_test("xstring::xstring(const xstring& str):");

  xstring v(5);
  if(v.allocatedsize() < 5 ) fail_test("xstring::xstring(long sz):a ");
  strcpy((char*)v.text(),"test");
  if(strcmp(v.text(),"test")) fail_test("xstring::xstring(long sz):b ");

  xstring w('a',4);
  if(strcmp(w.text(),"aaaa")) fail_test("xstring::xstring(char,long):");

  /* TODO: deprecated api!!!
  xstring x(t,4);
  if(strcmp(x.text(),"testtesttesttest")) fail_test("xstring::xstring(const xstring&, long):");

  xstring y("test",4); 
  if(strcmp(y.text(),"testtesttesttest")) fail_test("xstring::xstring(const xstr, long):");
  */
  return 0;
}
