// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  const xstr t="test1";
  
  xstring s(t);
  xstring r("test1");
 
  if(!(s == r)) fail_test("xstring::operator==():a ");
  r="";
  if(s == r) fail_test("xstring::operator==():b ");
  r="ciao";
  if(s == r) fail_test("xstring::operator==():c ");
  
  r="test1";
  if(!(r == s)) fail_test("xstring::operator==():d ");
  r="";
  if(r == s) fail_test("xstring::operator==():e ");
  r="ciao";
  if(r == s) fail_test("xstring::operator==():f ");
 
  r="tEsT1";
  if(s.comparenocase (r)) fail_test("xstring::operator==():g ");
  r="";
  if(s.comparenocase (r)==0) fail_test("xstring::operator==():h ");
  r="ciao";
  if(s.comparenocase(r)==0) fail_test("xstring::operator==():i ");
 
  r="tEsT1";
  if(r.comparenocase (s)) fail_test("xstring::operator==():j ");
  r="";
  if(r.comparenocase (s)==0) fail_test("xstring::operator==():k ");
  r="ciao";
  if(r.comparenocase(s)==0) fail_test("xstring::operator==():l ");
 
  return 0;
}
