// -*- Mode: C++ -*-
//
// This file is part of the xstring test suite
//
//    Copyright (C) 2004 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2.1 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//

#include <xstring.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

void fail_test(const char* msg)
{
  fputs(msg,stdout);
  exit (1);
}

int main(int argc, char** argv)
{
  const xstr t="testIfIworkCorrectly";
  xstring s(t);
  s.resize(100);
  s.adjust();

  if(s.allocatedsize()>strlen(t)+2) fail_test("xstring::adjust():a ");
  if(s.allocatedsize()<=strlen(t)) fail_test("xstring::adjust():b ");

  if(strcmp(s.text(),"testIfIworkCorrectly")) fail_test("xstring::adjust():c ");
  
  long l=strlen(t);
  s.resize(l+3);
  long a=s.allocatedsize();
  s[l]=1;
  s[l+1]=1;
  s[l+2]=1;
  // s[l+3]=1;
  ((char*)s.text())[l+3]=1;
  s.adjust();
  if(s.allocatedsize()!=a) fail_test("xstring::adjust():d ");
  
  return 0;
}
