// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __WORKER_H__
#define __WORKER_H__

class InputConn;
class HTTPInternalProxy;


class Worker : public virtual SchedEndpoint
{
  int pid;
  int requested;
  //FD w;
  InputConn *c;
  HTTPConnection *co;
  
  HTTPRequestHeader *rh;

  int status;
  xstring buff;
  __int64_t contentlen;
  __int64_t pos,cur;

  HTTPInternalProxy* proxy;
  xstring startline;

public:
  Worker(int fd,int pid,HTTPInternalProxy * ip);
  //int getfd();
  
  InputConn* getconn() { return c; };
  void setconn(InputConn* ic) { c=ic; if(c)status=1; else status=0;};
  int sched();
  int handleread();
  int handlewrite();
  int handleerror(){return 0;};

  int readstatusline();
  int readheaders();

  int readpostdata();
  int writeheaders();
  int inputconn_writeheaders();

  int checkcontentlength();



  int getstatus()const{return status;};

  void setrequested(int n) {requested=n;};
  int reset();

  enum {
    Ready=0,
    Error,
    Finished,
    NeedConnWrite,
    HeadersSent
  };

  enum {

    Req_WriteRequestLine,
    Req_WriteHeaders,
    Req_WritePostData,
    Req_ReadStatusLine,
    Req_ReadHeaders,
    Req_ReadPostData
  };
};


#endif //__WORKER_H__

