// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <errno.h>

#include "nhttpd.h"
#include "worker.h"
#include "inputconn.h"
#include "schedendpoint.h"
#include "httpinternalproxy.h"


Worker::Worker(int fd,int pid,
  HTTPInternalProxy* ip)
  :Object ("Worker"),SchedEndpoint(fd)
{
  pos=0;
  co = new HTTPConnection( this->r);
  rh=new HTTPRequestHeader (co);  
  this->pid=pid;
  c=NULL;
  proxy=ip;
  status=0;
  requested=0;
  cur=0;
}

int Worker::readstatusline()
{
  MYTRACE("readstatusline()");
  // get start line !
  xstring line;
	
  int l = rh->readstartline(line,HTTPRequestHeader::CHECK_STATUSLINE,false);
#ifdef DEBUG
  std::cout << "line: " << line << std::endl;
  std::cout << "l: " << l << std::endl;
#endif
  if (l < 0)
    {
      return -1;
    }
  else if (l==0)
    {
	    // wait for data
      return 0;
    }
  else 
    {
      rh->clear();
      setrequested(Req_ReadHeaders);
      setfdmask(READ);
      return 1;
    }
}

int Worker::readheaders()
{
  MYTRACE("readheaders()");
  int s = rh->sched();
  if (s == HTTPRequestHeader::Complete)
    {
      pos=co->position();
#ifdef DEBUG
      cout << "pos: " << pos << endl;
#endif
      //buff ="";
      if (checkcontentlength()>0)
	{
	  c->setfdmask (0);
	  setfdmask(READ);
	  setrequested(Req_ReadPostData);
	}
      else
	{
	  c->setfdmask(WRITE); // request for writing data
	  setfdmask(0);
	  setrequested (-1);
	  c->setrequested(InputConn::Req_WriteHeaders);	
	}
      return 1;
    }
  else if (s == HTTPRequestHeader::Error)
    {
      return -1;
    }
  else if (s== HTTPRequestHeader::NotComplete)
    {
      // wait for data
      return 0;
    }
  //break;
	
}

int Worker::checkcontentlength()
{
  if (rh->hasitem("Content-Length"))
    {
      xstring s = rh->getitem("Content-Length");
#ifdef DEBUG
      cout << "content length:" << s << endl; 
#endif
      contentlen= atoll(s.text());
    }
  else
    contentlen=0;
 
  return contentlen;
}

int Worker::readpostdata()
{
  MYTRACE("readpostdata()");
  // process also the content data (POST or PUT)
  if (contentlen>0)
    {
      int n = NHBUFFERLEN;
      /*
	if(c->popn(n)<0)
	return status=Error;
      */
      if (co->buffer().length() < pos + contentlen)
	{
	  int r=co->read(n);
	  if (r < 0 && errno!=EAGAIN)
	    return -1;
	  if (r==0)
	    return -1;
	}
      if (co->buffer().length() >= pos + contentlen)
	{
#ifdef DEBUG
	  std::cout << "received all " << contentlen << " bytes" << endl;
#endif
	  c->setfdmask(WRITE);
	  setfdmask(0);
	  setrequested(-1);
	  c->setrequested(InputConn::Req_WriteHeaders);
	  cur=0;
	  //co->position(c->position()+contentlen);
	  //co->clear();
	  // pass the control to the inputconn
	  return 1;
	}
      //	      break;
    }
  else
    {
      cur=0;
      return 1;
    }
  return 0;

}
int Worker::handleread()
{
  MYTRACE ("Worker::handleread()");
  
  fsync(getfd());

  int i=0;
  // TODO FIXME!! what if a new request remains buffered??

  if (requested== Req_ReadStatusLine)
    {
      i = readstatusline();
      if(i<=0) return i;
    }
  if (requested== Req_ReadHeaders)
    {
      i = readheaders();
      if (i<=0) return i;
    }
  if (requested== Req_ReadPostData)
    {
      i = readpostdata();
      if (i<=0) return i;
    }
  /*  
    break;
    default:
      MYTRACE("Error: tag not found!!");
      return -1;
    }
  */
  return 1;
}


int Worker::writeheaders()
{
  //c->setfdmask(READ);
  return c->worker_writeheaders();

  //  return 1;
}


int Worker::inputconn_writeheaders()
{
  MYTRACE ("Worker::inputconn_writeheaders()");

  if (contentlen<0) contentlen=0; // :-(
 
  int k=contentlen+pos-cur;
#ifdef DEBUG
  cout << "k:" << k << endl;
#endif

  xstring s=co->buffer().mid(cur,MIN(k,NHBUFFERLEN));
#ifdef DEBUG
  cout << "s created. len:" << s.length()<< endl;
#endif
  
  int n=c->send (s);
  if (n<0)
    if (errno==EAGAIN)
      return 0;
    else
      return -1;
  
  cur +=n;

  if (cur<contentlen+pos)
    {
      MYTRACE("not all data was sent\n");
      return 0;
    }
  

  MYTRACE("Resetting...");

  co->position(cur);
  co->clear();
  cur=0;
  
  setfdmask(0);
  setrequested (-1);
  c->setfdmask(READ);
  c->setrequested(InputConn::Req_ReadRequestLine);
 
 // Well DONE!!!
  c->reset();
  reset();
 
  return 1;
}


int Worker::handlewrite()
{

  MYTRACE ("Worker::handlewrite()");
  
  fsync(getfd());
  int i=0;

  switch (requested)
    {
    case Req_WriteHeaders:
      i = writeheaders();
      if (i<=0) return i;

      break;
    default:
      MYTRACE("Error: tag not found!!");
      return -1;
    }
  return 1;
  
}


int Worker::sched()
{
  
  return 0;
}


int Worker::reset()
{
  setconn(NULL);
  status=0;
  cur=0;
  return 0;
}
