// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __NYCOLAS_SYNTAX_H__
#define __NYCOLAS_SYNTAX_H__

#define CR "\r" 
#define LF "\n"
#define SP " "
#define HT "\t"
#define DQ "\""
#define CRLF CR LF

#define STRC_UPALPHA "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define STRC_LOALPHA "abcdefghijklmnopqrstuvwxyz"
#define STRC_DIGIT "0123456789"
#define STRC_CTL "\001\002\003\004\005\006\007\010\011\011\012\013\014\015\016\017\020\021\022\023\024\025\026\030\031"
#define STRC_HEX "abcdefABCDEF" STRC_DIGIT
#define STRC_TSPECIALS "()<>@,;:\\\\" DQ "/\\[\\]?={}" SP HT
#define STRC_RESERVED ";/?:@&=+"
#define STRC_EXTRA "!*'(),"
#define STRC_SAFE "$-_."
#define STRC_UNSAFE STRC_CTL SP DQ "#%<>"


#define TSPECIALS "][()<>@,;:\\/\"? \t"
#define regextoken "[^" TSPECIALS "\001-\031]\\+"
#define QUOTEDSTRING "\"[^\"]*\""
#define TEXT "[^\001-\031]"
#define field_content "\\(" TEXT "*\\|\\([" TSPECIALS "]\\|" regextoken "\\|" QUOTEDSTRING "\\)*\\)"

#endif // __NYCOLAS_SYNTAX_H__
