// -*- Mode: C++ -*-
// Copyright (C) 2004,x2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __NYCOLAS_SOCKET_H__
#define __NYCOLAS_SOCKET_H__

#include <netdb.h>
//#include <netinet/ip_compat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <sys/poll.h>
#include <unistd.h>

#include <fcntl.h>
#include <memory.h>
#include <string.h>
#include "common.h"
#include "object.h" 
#include "fd.h"

class Socket : public virtual FD
{
protected:

    
public:
  Socket(int fd=-1);
  virtual ~Socket();

  int shutdown(int how=SHUT_RDWR);
  //  int close();
  

  char* recv(int &n,int opts=0);

  int send (const char*s,int n=-1,int flags=0);

  int check_integrity() const;
};

#endif // __NYCOLAS_SOCKET_H__
