// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include <memory.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <errno.h>
#include <asm/errno.h>

#include "common.h"
#include "socket.h"

Socket::Socket(int fd)
  :Object("Socket"),FD(fd)
{

}

Socket::~Socket()
{
  if (fd >=0)
    {
      shutdown();
      close();
      checkval=0;
    }
}

int Socket::check_integrity() const
{
  if (fd < 0)
    { 
      // cout << "INETSocket Integrity Check: Error: invalid socket descriptor " << fd << endl;
      return -1;
    }
  return 0;
}

int Socket::shutdown(int how)
{
  if (check_integrity()<0) return checkval=-1;
  return checkval=::shutdown (fd,how);
}


char* Socket::recv(int & n,int opts)
{
  if (check_integrity()<0) return NULL;
  char * b=new char[n+5];
  n=::recv(fd,b,n,opts);
  if (n>=0) b[n]=0;
  else b[0]=0;
  checkval=n<0?n:0;
  return b;
}


int Socket::send(const char*s,int n,int flags)
{
  if (check_integrity()<0) return -1;
  int i;
  if(n<0) n=strlen(s);
  i=::send(fd,s,n,flags|MSG_NOSIGNAL);
  checkval=i<0?i:0;
  return i;
}
