// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include "server_socket.h"
#include <sys/select.h>
#include <errno.h>

ServerSocket::ServerSocket()
  :Object("ServerSocket"),FD(-1),Socket(-1)
{

  // create the socket
  fd = socket ( AF_INET, SOCK_STREAM,0);//SOCK_RAW,  IPPROTO_TCP);
 
  int f=1;
  setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,&f,sizeof(f));
  f=1;
  //  setsockopt(fd,SOL_SOCKET,SO_KEEPALIVE,&f,sizeof(f));
  
  //  struct linger linger_opt;
  //  linger_opt.l_onoff=1;
  // linger_opt.l_linger=1;
  // setsockopt(fd,SOL_SOCKET,SO_LINGER,&linger_opt,sizeof(linger_opt));
  
  //  long fflags=fcntl (fd, F_GETFL,0);
  //  fflags|=O_NONBLOCK;
  //  fcntl(fd,F_SETFL,fflags);

  memset (&local,0,sizeof(local));
  memset (&remote,0,sizeof(remote));
  
}

ServerSocket::~ServerSocket()
{

}


int ServerSocket::listen(int n)
{   
  cout << "listening on " << (hn?hn:"") << ":" << port << "..." << endl;
  int r = ::listen(fd, 10);  
  return checkval=r;
}

INETSocket *ServerSocket::accept()
{
  struct sockaddr addr;
  socklen_t len=sizeof(addr);
  int conn=::accept(fd,&addr,&len);

  checkval=conn;
  if (conn<0) 
    {
      perror ("SocketServer::accept()");
      return NULL;
    }
  int perrno=errno;
  char buff[256];
  getip(buff,((struct sockaddr_in*)&addr)->sin_addr);
  cout << "accepted connection from " << buff << ":" << ((struct sockaddr_in*)&addr)->sin_port << endl;
  INETSocket *a = new INETSocket(conn,local,*((sockaddr_in*)&addr));
  errno=perrno;
  return a;
}

#if 0
/* Non c'entra!!
int ServerSocket::handle(int timeoutsec)
{
  fd_set rdfs;
  FD_ZERO(&rdfs);
  FD_SET(getfd(),&rdfs);

  struct timeval tv;
  tv.tv_sec=(timeoutsec>=0?timeoutsec:0);
  tv.tv_usec=0;
  
  int r= select (1,&rdfs,NULL,NULL,&tv);
  if(r==-1)
    {
      perror("ServerSocket::handle(): select()");
    }
  else if (r)
    {
      if (FD_ISSET(0,&rdfs))
	{
	  int n=1023;
	  char *q=s.recv(n);
	  cout << "read " << q << " bytes\n";
	  cout << "data: " << q << "data-end" <<endl;
	  delete [] q;
	}
    }
  else
    {
      cout << "No data -- timeout\n";
    }
  
  return 0;
}
*/
#endif
