// -*- Mode: C++ -*-
// Copyright (C) 2004-2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <sys/types.h>
#include <sys/wait.h>

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <unistd.h>
#include <limits.h>
#include <sys/mman.h>

#include "schedendpointlist.h"

#ifndef MIN
# define MIN(a,b)((a)>(b)?(b):(a))
#endif


#ifndef MAX
# define MAX(a,b) ((a)>(b)?(a):(b))
#endif


SchedEndpointList::SchedEndpointList()
  :Object("SchedEndpointList"),ObjectList()
{
  
}

void SchedEndpointList::add(SchedEndpoint * w)
{
  additem(w);
}

void SchedEndpointList::remove(SchedEndpoint * w)
{
  ObjectList::Item  * i=head();
  for (int j=0; i; ++j,i=i->next())
    {
      if (w == dynamic_cast <SchedEndpoint*>(i->value()))
	{
	  removeitem(i);
	  break;
	}
    }
}

int SchedEndpointList::setfdset(fd_set *read,fd_set *write, fd_set* error)
{
  int n=getsize();

  int max=0;

  Item * i=head();
  SchedEndpoint * w;

  for (;i;i=i->next())
    {
      w=dynamic_cast<SchedEndpoint *>(i->value());
      int fd=w->getfd();
      int m = w->getfdmask();

      if (m& SchedEndpoint::READ)
	{
	  max=MAX(fd,max);	  
	  FD_SET(fd,read);
	}
      else if (m & SchedEndpoint::WRITE)	
	{
	  max=MAX(fd,max);
	  FD_SET(fd,write);
	}
      else if (m & SchedEndpoint::ERROR)	
	{
	  max=MAX(fd,max);
	  FD_SET(fd,error);
	}    
    }
  return max;
}

