// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __SCHED_ENDPOINT_H__
#define __SCHED_ENDPOINT_H__

#include "object.h"
#include "socket.h"

class SchedEndpoint: public virtual Object
{
protected:
  Socket *r;
  int mask;
public:
  SchedEndpoint (int s); 
  virtual ~SchedEndpoint();
  virtual int getfd();
  int send(const xstring & data);  
  void setfdmask(int m);
  int getfdmask() const;

  enum {
    NONE = 0,
    READ = 1,
    WRITE= 2,
    ERROR= 4
  };
};

 
#endif // __SCHED_ENDPOINT_H__
