// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "schedendpoint.h"

SchedEndpoint::SchedEndpoint(int readfd)
  :Object ("SchedEndpoint")
{
  r=new Socket (readfd);
  mask=0;
}

SchedEndpoint::~SchedEndpoint()
{
  delete r;
}

int SchedEndpoint::getfd()
{
  return r->getfd();
}

int SchedEndpoint::send(const xstring & data)
{
  fdatasync(r->getfd()); // sync!! this is really needed
  int n= r->send(data.text(),data.length());
#ifdef DEBUG
  std::cout << "SchedEndPoint::send(): send returned " << n << std::endl; 
  if(n<0) perror("SchedEndPoint::send()");
#endif
  // fsync(r->getfd());
  fdatasync(r->getfd()); // sync!! this is really needed
  return n;
}

void SchedEndpoint::setfdmask(int m)
{
  mask=m;
}

int SchedEndpoint::getfdmask() const
{
  return mask;
}
