// -*- Mode: C++ -*-
//
//    ObjectList - a list of objects
//
//    Copyright (C) 2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 

#ifndef __OBJECT_LIST_H__
#define __OBJECT_LIST_H__
#include "object.h"

class ObjectList : public virtual Object
{  

public:

  class Item
  {
    Object * my_value;
    Item * my_next;
    Item* my_prev;

  public:
    Item(Object *value);
    Item(const Item& copy);
    
    ~Item();
    
    Item* next();
    const Item* next() const;

    /* 
       Item* prev();
       const Item* prev() const;
    */
    
    Object* value() const;
    
    void set(Object *value);
    Item& operator=(Object* value);
    
    void setnext(Item* i);

    friend class ObjectList;
  };
private:

  Item *my_head;
public:

  ObjectList();

  ObjectList(Object * values, size_t n);
  ~ObjectList();


  void fromvector(Object* values, size_t n);
  
  Item* head();
  const Item* head() const;

  Item* tail();
  const Item* tail() const;

  Item* getitem(size_t index);
  const Item* getitem(size_t index) const;
  
  Object* getvalue (size_t index) const ;

  size_t getsize() const;

  bool hasitem (Item * i) const;
  bool hasitem (size_t index) const;

  void additem(Item* o);
  void additem(Object* value);
 
  void removeitem (size_t index);
  void removeitem (Item * i);

  void clear();

};

#endif // __OBJECT_LIST_H__

