// -*- Mode: C++ -*-
//
//    Object - an abstract base class for all objects..
//
//    Copyright (C) 2005 Aldo Nicolas Bruno
//
//    Linux Users Group San Fidenzio
//

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ 
#include "object.h"

Object::Object(const xstring& name)
  :  my_name(name),my_refcount(1)
{

}

Object::~Object()
{
  
}

void Object::inc()
{
  my_refcount++;
}

void Object::dec()
{
  my_refcount--;
  if (my_refcount<=0)
    {
      delete this;
    }
}
