// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __INPUTCONN_H__
#define __INPUTCONN_H__

#include "schedendpoint.h"
#include "worker.h"
class HTTPInternalProxy;

class InputConn : public virtual SchedEndpoint
{
  Worker *w;
  HTTPConnection *c;
  
  HTTPRequestHeader *rh;
  xstring buff;
  int status;
  __int64_t contentlen;
  int requested;
  xstring startline;
  __int64_t pos,cur;

  HTTPInternalProxy* proxy;

public:
  enum {
    Error,
    Finished,
    Ready,
    StartLineReady,
    HeadersReady,
    NeedWorker
    
  };

  InputConn(int fd, HTTPInternalProxy * ip);
  ~InputConn ();

  __int64_t getcontentlen() const{return contentlen; };
  int sched();
  const xstring& getbuffer()const{ return c->buffer(); };
  HTTPConnection* getconn() {return c; };
  Worker* getworker() { return w; };
  void setworker (Worker* wo) { w= wo; };
  
  int getstatus() { return status; };

  int handleread();
  int handlewrite();
  int handleerror(){return 0;};

  int readrequestline();
  int readheaders();

  int readpostdata();
  int writeheaders();
  int worker_writeheaders();

  int checkcontentlength();



  int reset();

  void setrequested(int n) {requested=n;};
  enum {
    Req_ReadRequestLine,
    Req_ReadHeaders,
    Req_ReadPostData,
    Req_WriteStatusLine,
    Req_WriteHeaders,
    Req_WritePostData
  };
};

#endif // __INPUTCONN_H__
