// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <errno.h>

#include "nhttpd.h"
#include "inputconn.h"
#include "httpinternalproxy.h"

InputConn::InputConn(int fd,HTTPInternalProxy* ip)
  :Object ("InputConn"),SchedEndpoint(fd),status (Ready),contentlen(0)
{
  c = new HTTPConnection( this->r);
  rh=new HTTPRequestHeader (c);  
  w=NULL;
  proxy=ip;
  requested=0;
  pos=0;
  cur=0;
}

InputConn::~InputConn ()
{
  if (c) delete c;
  if (rh ) delete rh;
}

int InputConn::readrequestline()
{  
  MYTRACE("readrequestline()");

  int l = rh->readstartline(startline,HTTPRequestHeader::CHECK_REQUESTLINE,false);
#ifdef DEBUG
  std::cout << "line: " << startline << std::endl;
  std::cout << "l: " << l << std::endl;
#endif 

  if (l < 0)
    {
      return -1;
    }
  else if (l==0)
    {
      return 0;
      //do nothing and wait for data
    }
  else 
    {
      
      setfdmask(READ);
      setrequested(Req_ReadHeaders);
      
      rh->clear();
      return 1;
    }

  //break;
}

int InputConn::readheaders()
{
  MYTRACE("readheaders()");

  int s = rh->sched();
  if (s == HTTPRequestHeader::Complete)
    {
      //  buff = c->getbuffer().left(c->position());

      pos=c->position();


#ifdef DEBUG
      cout << "pos: "<< pos << endl;
#endif

      if (checkcontentlength()>0)
	{
	  setfdmask(READ);
	  setrequested(Req_ReadPostData);
	}
      else 
	{
	  Worker * w = proxy->getidle();
	  setworker(w);
	  
	  MYASSERT(w);
	  w->setconn(this);
	  w->setfdmask(WRITE); // request for writing data
	  setfdmask(0);
	  setrequested (-1);
	  w->setrequested(Worker::Req_WriteHeaders); 
	}
      return 1;
    }
  else if (s == HTTPRequestHeader::Error)
    {
      return -1;
    }
  else if (s== HTTPRequestHeader::NotComplete)
    {
      // do nothing and wait for data
      return 0;
    }
  return -1;
  //break;  
}

int InputConn::checkcontentlength()
{
  if (rh->hasitem("Content-Length"))
    {
      xstring s = rh->getitem("Content-Length");
#ifdef DEBUG
      cout << "content length:" << s << endl; 
#endif

      contentlen= atoll(s.text());
    }
  else
    contentlen=0;
  return contentlen;
}

int InputConn::readpostdata()
{
  MYTRACE("readpostdata()");

  // process also the content data (POST or PUT)
  if (contentlen>0)
    {
      int n = NHBUFFERLEN;
      /*
	if(c->popn(n)<0)
	return status=Error;
      */
      if (c->buffer().length() < pos + contentlen)
	{
	  int r;
	  if((r=c->read(n) ) < 0 && errno!=EAGAIN)
	    return -1;
	  if (r==0) 
	    return -1;
	}
      if (c->buffer().length() >= pos + contentlen)
	{
#ifdef DEBUG
	  std::cout << "received all " << contentlen << " bytes" << endl;
#endif 

	  Worker * w = proxy->getidle();
	  setworker(w);
	  
	  MYASSERT(w);
	  w->setconn(this);
	  w->setfdmask(WRITE); // request for writing data
	  cur=0;
	  setfdmask(0);
	  setrequested (-1);
	  w->setrequested(Worker::Req_WriteHeaders); 


	  return 1;
	}
      else
	return 0;
      //	      break;
    }else return -1;
  cur=0;
  return 1;
}

int InputConn::handleread()
{
  MYTRACE ("InputConn::handleread()");

  fsync(getfd());  
  
  int i=0;
  // TODO FIXME!! what if a new request remains buffered??
  if (requested== Req_ReadRequestLine)
    {
      i = readrequestline();
      if(i<=0) return i;
    }

  if (requested== Req_ReadHeaders)
    {
      i = readheaders();
      if (i<=0) return i;
    }
  if (requested== Req_ReadPostData)
    {
      i = readpostdata();
      if (i<=0) return i;
    }
    
  //     MYTRACE("Error: tag not found!!");
  //    return -1;
  //  }
  return 1;
}

int InputConn::handlewrite()
{
  MYTRACE ("InputConn::handlewrite()");
  
  fsync(getfd());
  int i=0;

  if (requested== Req_WriteHeaders)
    {
      i = writeheaders();
      if (i<=0) return i;

    }
  /*
    default:
      MYTRACE("Error: tag not found!!");
      return -1;
    }
  */
  return 1;
}

int InputConn::writeheaders()
{
  //c->setfdmask(READ);
  return w->inputconn_writeheaders();

  //  return 1;
}

int InputConn::worker_writeheaders()
{
  MYTRACE("InputConn::worker_writeheaders()");

  int k=contentlen+pos-cur;

#ifdef DEBUG
  cout << "k:" << k << endl;
  cout << "contentlen:" << contentlen << endl;
  cout << "pos:" << pos << endl;
  cout << "cur:" << cur << endl;
#endif 

  const xstring & data=c->buffer().mid(cur,MIN(k,NHBUFFERLEN));
#ifdef DEBUG  
  cout << "data: " << data << endl;
#endif

  int n=w->send (data);

  if(n<0)
    if (errno==EAGAIN)
      return 0;
    else
      return n;
  else if (n==0)
    return -1;

  cur+=n;
  if (cur<contentlen+pos)
    {
      MYTRACE("not all data was sent\n");
      return 0;
    }

  c->position(cur);
  c->clear();
  cur=0;
  w->setrequested(Worker::Req_ReadStatusLine);
  w->setfdmask(Worker::READ);

  return 1;
}

int InputConn::sched()
{
  MYTRACE ("InputConn::sched()");

  fsync(getfd());

}

int InputConn::reset()
{
  MYTRACE("reset()");

  setworker(NULL);
  status=0;
  cur=0;
  return 0;
}
