// -*- Mode: C++ -*-
// Copyright (C) 2004,2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __NYCOLAS_INETSOCKET_H__
#define __NYCOLAS_INETSOCKET_H__

#include <netdb.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <sys/poll.h>
#include <unistd.h>
#include <arpa/inet.h>

#include "socket.h"

class INETSocket : public virtual Socket
{
protected:
  struct sockaddr_in local,remote;
  struct hostent* h;
  char* hn;
  int port;

public:
  INETSocket();

  INETSocket(int fd, struct sockaddr_in local, struct sockaddr_in remote);

  struct sockaddr_in* getlocaladdr();
  struct sockaddr_in* getremoteaddr();

  int connect (const char* host, int port);
  int bind(const char* host, int port);
  
  static void getip(char* buff,struct in_addr addr);

  virtual ~INETSocket();
};

#endif // __NYCOLAS_INETSOCKET_H__
