// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __NYCOLAS_HTTP_TIME_H__
#define __NYCOLAS_HTTP_TIME_H__
#include "object.h"

class HTTPTime: public virtual Object
{
  time_t t;

 public:
  HTTPTime(){t=0;}
  HTTPTime(time_t time);
  HTTPTime(const xstring& timestring);
  
  bool from_rfc1123(const xstring& timestring);
  bool from_rfc1036(const xstring& timestring);
  bool from_asctime(const xstring& timestring);

  // Guess the correct syntax
  void fromstring(const xstring& timestring);
  
  xstring get_rfc1123() const;
  xstring get_cookietime() const;

  //  xstring get_rfc1036() const;
  //  xstring get_asctime() const;
  
  time_t gettime() const;
};

#endif //__NYCOLAS_HTTP_TIME_H__
