// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <errno.h>
#include <xstring.h>
#include "server_socket.h"

#include "httpserver.h"
#include "httpconnection.h"

#include "httpservertoken.h"


HTTPServerToken::HTTPServerToken(HTTPConnection* s)
{
  conn=s; 
}

// non-blocking
xstring HTTPServerToken::gettoken(char c, int blocking)
{
  xstring token="";
  xstring buff;
  long l;
  long i=0;
  long start=1;

  while(!conn->timeout()) // forever
    {
      if(start && conn->bufferready())
	buff=conn->buffernew();
      else
	{
	  if (blocking)
	    {
	      int r=conn->readblocking();
	      if (r<=0) return "";
	    
	    }
	  else
	    {
	      int n =conn->read();
	      if (n<1)
		{
		  
		  return "";
		}
	    }
	  buff=conn->buffernew();
	}

      start = false;

      l=buff.length();
      for (i=(i<1?0:i-1); i<l ; ++i)
	{
	  if (buff[i]==c)
	  {
	    token=buff.mid(0,i);
	    conn->position(conn->position()+i+1);
	    return token;
	  }
	}
    }
  return "";
}


int HTTPServerToken::gettoken( const xstringvector& seplist, xstring& token, int blocking, xstring* sepfound)
{
  token="";
  xstring buff;
  long l=0;
  long i=0,j;
  long start=1;
  long nseps=seplist.n();

  int status=1; // not complete

  if (nseps<=0) return -1;

  long * lslist=new long [nseps+1];

  long max=0;
  for (j=0; j< nseps; ++j)
    {
      lslist[j]=seplist[j].length();
      if (lslist[j]>max) max=lslist[j];
    }

  while(!conn->timeout()) // forever
    {

      if(start && conn->bufferready())
	buff=conn->buffernew();
      else
	{
	  if (blocking)
	    {
	      int n=conn->readblocking();
	      if (n<=0)
		{
		  if (errno!=EAGAIN)
		    status=n;
		  break;
		}
	    }
	  else
	    {
	      int n =conn->read();
	      if (n==0)
		{
		  status=n;
		  break;
		}
		
	      if (n<0)
		{
		  if (errno!=EAGAIN)
		    status=n;
		  break;
		}
	    }
	   buff=conn->buffernew();
	}
      start = false;

      l=buff.length();
      if (!l) continue; // ???
      xstring a,b;  
      for (i=(i<max?0:i-max); i<l ; ++i)
	{
	  for (j=0; j< nseps; j++)
	    {
	      a=buff.mid(i,lslist[j]);
	      b=seplist[j];
	      if (a==b)
		{
		  token=buff.mid(0,i);
		  if (sepfound) *sepfound=seplist[j];
		  conn->position(conn->position()+i+lslist[j]);
		  status=0;
		  goto finish;
		}
	    }
	}
      
    }
  if(sepfound) *sepfound="";
 finish:
  delete [] lslist;
  
#ifdef DEBUG
  std::cout << "HTTPServerToken::gettoken(): status: " << status << std::endl;
#endif
  return status;

}
