// -*- Mode: C++ -*-
// Copyright (C) 2005 Aldo Nicolas Bruno

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __NYCOLAS_HTTP_SERVER_H__
#define __NYCOLAS_HTTP_SERVER_H__



#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include <regex.h>

#include <xstring.h>
#include "server_socket.h"
#include "object.h"
#include "objectlist.h"
#include "schedendpoint.h"
//#include "worker.h"

class HTTPConnection;

class HTTPResource;
class SchedEndpointList;
class HTTPInternalProxy;
class Worker;

typedef struct httpresourcemap
{
  xstring name;
  HTTPResource *res;
  httpresourcemap * next;
}httpresourcemap; 


class HTTPServer : public virtual Object
{
  //  HTTPServer(){};
  //  Socket* socket;
  ServerSocket *server;
  httpresourcemap *firstres, *lastres;

  xstring docroot,uri,hostname,ip;
  int port;
  HTTPInternalProxy* iproxy;

public:
  HTTPServer();
  virtual ~HTTPServer();
  ServerSocket * getsocket();

  int initialize();
  int handlerequest (xstring data);
  int handle(int n, long secs=0);
  int handleone(Socket *x);
  int handleall();

  // for implementation by derived classes
  // here you should initialize the resources in a
  // per process basis... so each [Worker] process executes this
  // before the main loop (select)
  virtual int oninit(); 

  Worker* createworker();
  int addworker (SchedEndpointList& workers);

  int processrequestline(HTTPConnection* c, const xstring& requestline);

  int bind (const xstring& hostname, int port);
  int listen();
  Socket* acceptone();
  int addres(const xstring& name, HTTPResource *r);
  httpresourcemap* getfirstres(){ return firstres; }
  httpresourcemap* getlastres(){ return lastres; }

  void setdocroot(const xstring& root);
  xstring getdocroot() const;
  
  xstring geturi() const;
  xstring gethostname() const;
  int getport() const;
  xstring getip() const;

};

#endif // __NYCOLAS_HTTP_SERVER_H__
